package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: PurthId</p>
 * <p>Description: 进货单单身档主键</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/25
 */
public class PurthId implements Serializable {
    public PurthId() {
    }

    public PurthId(String th001, String th002, String th003) {
        this.th001 = String.format("%1$-4s", th001);
        this.th002 = String.format("%1$-11s", th002);
        this.th003 = String.format("%1$-4s", th003);
    }

    private String th001;
    private String th002;
    private String th003;

    public String getTh001() {
        return th001;
    }

    public void setTh001(String th001) {
        this.th001 = th001;
    }

    public String getTh002() {
        return th002;
    }

    public void setTh002(String th002) {
        this.th002 = th002;
    }

    public String getTh003() {
        return th003;
    }

    public void setTh003(String th003) {
        this.th003 = th003;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PurthId purthId = (PurthId) o;
        return th001.equals(purthId.th001) && th002.equals(purthId.th002) && th003.equals(purthId.th003);
    }

    @Override
    public int hashCode() {
        return Objects.hash(th001, th002, th003);
    }
}
