package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import java.math.BigDecimal;

/**
 * <p>Title: Invta</p>
 * <p>Description: 交易单据单头档</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/12/27
 */
@Data
@Entity
@IdClass(InvtaId.class)
public class Invta extends EntityBase {
    /**
     * 105：盘盈
     * 106：盘亏
     */
    @Id
    @ApiModelProperty("单别")
    private String ta001;
    @Id
    @ApiModelProperty("单号")
    private String ta002;
    @ApiModelProperty("交易日期")
    private String ta003;
    @ApiModelProperty("部门编号")
    private String ta004;
    @ApiModelProperty("备注")
    private String ta005;
    @ApiModelProperty("审核码")
    private String ta006;
    @ApiModelProperty("打印次数")
    private Integer ta007;
    @ApiModelProperty("工厂编号")
    private String ta008;
    @ApiModelProperty("单据性质码")
    private String ta009;
    @ApiModelProperty("件数")
    private Integer ta010=0;
    @ApiModelProperty("总数量")
    private BigDecimal ta011;
    @ApiModelProperty("总金额")
    private BigDecimal ta012;
    @ApiModelProperty("生成分录")
    private String ta013="N";
    @ApiModelProperty("单据日期")
    private String ta014;
    @ApiModelProperty("审核者")
    private String ta015;
    @ApiModelProperty("总包装数量")
    private BigDecimal ta016;
    @ApiModelProperty("签核状态码")
    private String ta017;
    @ApiModelProperty("海关手册")
    private String ta018;
    @ApiModelProperty("审批意见")
    private String ta019;
    @ApiModelProperty("不合格原因")
    private String ta020;
    @ApiModelProperty("传送次数")
    private Integer ta021;
    @ApiModelProperty("汇入日期")
    private String ta022;
    @ApiModelProperty("门店编号")
    private String ta023;
    @ApiModelProperty("对方汇出日期")
    private String ta024;
}
