package com.topsunit.scanservice.ximai.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.util.List;

/**
 * 销售出库参数
 */
@Data
public class StockSaleOutDto {

    @ApiModelProperty("交货单号")
    String applyNo;

    @ApiModelProperty("通知单明细")
    List<StockSaleOutDetail> data;
    @Data
    public static class StockSaleOutDetail{
        @ApiModelProperty("物料号")
        String materialNo;
        @ApiModelProperty("物料名称")
        String materialName;
        @ApiModelProperty("计划出库日期")
        String planOutDate;
        @ApiModelProperty("单位")
        String unit;
        @ApiModelProperty("交货数量")
        BigDecimal deliverQuantity;
    }
}
