package com.topsunit.scanservice.ximai.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Id;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>Title: PurtaCreateParams</p>
 * <p>Description: PurtaCreateParams</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/22
 */
@Data
public class PurtaCreateParams {

    @Id
    @ApiModelProperty("请购单别")
    private String ta001="471";
    @Id
    @ApiModelProperty("请购单号")
    private String ta002;

    @ApiModelProperty("工单单别")
    private String workorderType;

    @ApiModelProperty("工单单号")
    private String workorderCode;

    @ApiModelProperty("请购日期")
    private String ta003;
    @ApiModelProperty("请购部门")
    private String ta004="04";
    @ApiModelProperty("审核码")
    private String ta007="Y";
    @ApiModelProperty("数量合计")
    private BigDecimal ta011=BigDecimal.ONE;
    @ApiModelProperty("来源")
    private String ta009="9";
    @ApiModelProperty("工厂")
    private String ta010="01";
    @ApiModelProperty("客户订单号")
    private String udf02;
    @ApiModelProperty("销售单号")
    private String udf03;
    @ApiModelProperty("单据日期")
    private String ta013;
    @ApiModelProperty("备注")
    private String ta006;
    @ApiModelProperty("明细")
    private List<PurtbCreateParams> details;

}
