package com.topsunit.scanservice.ximai.dto;

import com.topsunit.scanservice.ximai.common.Constants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Id;
import java.math.BigDecimal;

/**
 * 销货单单身档
 */
@Data
public class CopthCreateParams {
    @Id
    @ApiModelProperty("单别")
    private String th001;
    @Id
    @ApiModelProperty("单号")
    private String th002;
    @Id
    @ApiModelProperty("序号")
    private String th003;
    @ApiModelProperty("品号")
    private String th004;
    @ApiModelProperty("品名")
    private String th005;
    @ApiModelProperty("规格")
    private String th006;
    @ApiModelProperty("仓库")
    private String th007;
    @ApiModelProperty("数量")
    private BigDecimal th008;
    @ApiModelProperty("单位")
    private String th009;
    @ApiModelProperty("库存数量")
    private BigDecimal th010=BigDecimal.ZERO;
    @ApiModelProperty("小单位")
    private String th011="";
    @ApiModelProperty("单价")
    private BigDecimal th012;
    @ApiModelProperty("金额")
    private BigDecimal th013;
    @ApiModelProperty("订单单别")
    private String th014;
    @ApiModelProperty("订单单号")
    private String th015;
    @ApiModelProperty("订单序号")
    private String th016;
    @ApiModelProperty("批号")
    private String th017= Constants.BATCH_DEF;
    @ApiModelProperty("备注")
    private String th018;
    @ApiModelProperty("客户品号")
    private String th019;
    @ApiModelProperty("审核码")
    private String th020="N";
    @ApiModelProperty("更新码")
    private String th021="N";
    @ApiModelProperty("保留字段")
    private String th022="";
    @ApiModelProperty("保留字段")
    private String th023="";
    @ApiModelProperty("赠/备品量")
    private BigDecimal th024=BigDecimal.ZERO;
    @ApiModelProperty("折扣率")
    private BigDecimal th025=BigDecimal.ONE;
    @ApiModelProperty("结账码")
    private String th026="N";
    @ApiModelProperty("结账单别")
    private String th027="";
    @ApiModelProperty("结账单号")
    private String th028="";
    @ApiModelProperty("结账序号")
    private String th029="";
    @ApiModelProperty("项目编号")
    private String th030;
    @ApiModelProperty("类型")
    private String th031="";
    @ApiModelProperty("借出单别")
    private String th032="";
    @ApiModelProperty("借出单号")
    private String th033;
    @ApiModelProperty("借出序号")
    private String th034="";
    @ApiModelProperty("原币税前金额")
    private BigDecimal th035;
    @ApiModelProperty("原币税额")
    private BigDecimal th036;
    @ApiModelProperty("本币税前金额")
    private BigDecimal th037;
    @ApiModelProperty("本币税额")
    private BigDecimal th038;
    @ApiModelProperty("包装数量")
    private BigDecimal th039=BigDecimal.ZERO;
    @ApiModelProperty("赠/备品包装量")
    private BigDecimal th040=BigDecimal.ZERO;
    @ApiModelProperty("包装单位")
    private String th041="";
    @ApiModelProperty("已结账数量")
    private BigDecimal th042=BigDecimal.ZERO;
    @ApiModelProperty("件装")
    private BigDecimal th043=BigDecimal.ZERO;
    @ApiModelProperty("件数")
    private BigDecimal th044=BigDecimal.ZERO;
    @ApiModelProperty("出货通知单别")
    private String th045;
    @ApiModelProperty("出货通知单号")
    private String th046;
    @ApiModelProperty("出货通知序号")
    private String th047;
    @ApiModelProperty("预留字段")
    private BigDecimal th048;
    @ApiModelProperty("批发价")
    private BigDecimal th049=BigDecimal.ZERO;
    @ApiModelProperty("零售价")
    private BigDecimal th050=BigDecimal.ZERO;
    @ApiModelProperty("生产日期")
    private String th051="";
    @ApiModelProperty("有效日期")
    private String th052="";
    @ApiModelProperty("复检日期")
    private String th053="";
    @ApiModelProperty("原始客户")
    private String th054="";
    @ApiModelProperty("批号说明")
    private String th055="";
    @ApiModelProperty("库位")
    private String th056;
}
