package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.common.Version;
import com.topsunit.scanservice.ximai.dto.ChangePasswordParams;
import com.topsunit.scanservice.ximai.dto.LoginParams;
import com.topsunit.scanservice.ximai.dto.LoginResult;
import com.topsunit.scanservice.ximai.dto.SetPasswordParams;
import com.topsunit.scanservice.ximai.security.PassToken;
import com.topsunit.scanservice.ximai.service.CmsmvService;
import com.topsunit.scanservice.ximai.webapi.MesLoginService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>Title: CmsmvController</p>
 * <p>Description: 员工基本信息档</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/18
 */
@Api("员工基本信息档")
@RestController
public class CmsmvController {
    private final CmsmvService cmsmvService;

    public CmsmvController(CmsmvService cmsmvService) {
        this.cmsmvService = cmsmvService;
    }

    @ApiOperation("登录")
    @PassToken
    @PostMapping("/login")
    public LoginResult login(@RequestBody LoginParams loginParams) {
        return cmsmvService.loginByMes(loginParams);
    }

    @PassToken
    @PostMapping("/cmsmv/setpassword")
    public void setPassword(@RequestBody SetPasswordParams params){
        cmsmvService.setPassword(params);
    }

    @PostMapping("/cmsmv/changepassword")
    public void changePassword(@RequestBody ChangePasswordParams params){
        cmsmvService.changePassword(params);
    }

    @GetMapping("/v")
    public Version version(){
        return  Version.INSTANCE;
    }
}
