package com.topsunit.scanservice.ximai.utils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

@Component
public class MessageUtils {
    private static MessageSource messageSource;

    @Autowired
    private MessageSource messageSourceCopy;

    @PostConstruct
    private void init() {
        setMessageSource(messageSourceCopy);
    }

    private static synchronized void setMessageSource(MessageSource ms) {
        messageSource = ms;
    }

    public static String getMessage(String code, Object ... arg) {
        Object[] args = arg.clone();
        return messageSource.getMessage(code, args, LocaleContextHolder.getLocale());
    }
}
