package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.PurtgCreateCriteria;
import com.topsunit.scanservice.ximai.dto.PurtgCreateDto;
import com.topsunit.scanservice.ximai.dto.PurtgCreateParams;
import com.topsunit.scanservice.ximai.service.PurtgService;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.Optional;

/**
 * <p>Title: PurtgController</p>
 * <p>Description: 进货单</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/25
 */
@RestController
public class PurtgController {
    private final PurtgService purtgService;

    public PurtgController(PurtgService purtgService) {
        this.purtgService = purtgService;
    }

    @ApiOperation("查询进货单创建列表")
    @PostMapping("/purtg/getforcreate")
    public Optional<PurtgCreateDto> getForCreate(@RequestBody PurtgCreateCriteria criteria){
        return purtgService.getForCreate(criteria);
    }

    @ApiOperation("创建进货单")
    @PostMapping("/purtg/create")
    public void create(@RequestBody PurtgCreateParams purtgCreateParams){
        purtgService.create(purtgCreateParams);
    }
}
