package com.huigou.uasp.bmp.opm.controller;

import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.easysearch.domain.model.EasySearchParse;
import com.huigou.uasp.bmp.common.easysearch.domain.model.QuerySchemeField;
import com.huigou.uasp.bmp.opm.application.MemEasySearcher;
import com.huigou.uasp.bmp.opm.domain.model.resource.Link;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.huigou.util.Constants.EASY_SEARCH_DATA;

/**
 * @author yonghuan
 */
@ControllerMapping("link")
@Controller
public class LinkController extends CommonController implements ApplicationListener<ContextRefreshedEvent> {

    private final static Logger LOG = LoggerFactory.getLogger(LinkController.class);
    @Autowired
    private RequestMappingHandlerMapping handlerMapping;
    @Autowired
    private MemEasySearcher<Link> memSearcher;
    private Collection<Link> links;

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        syncLinksInternal();
    }

    /**
     * 同步链接
     */
    public String syncLinks() {
        syncLinksInternal();
        return success();
    }

    /**
     * 搜索链接
     */
    public String easySearch() {
        SDO sdo = getSDO();
        Integer intPage = sdo.getInteger("intPage", 1);
        Integer pageSize = sdo.getInteger("pageSize");
        PageRequest pageRequest = new PageRequest(intPage - 1, pageSize);
        String paramValue = sdo.getString("paramValue");
        EasySearchParse easySearchParse = new EasySearchParse();
        List<QuerySchemeField> fields = Collections.singletonList(new QuerySchemeField("地址", "url", "string", 400L));
        easySearchParse.setFields(fields);
        easySearchParse.setWidth(400L);
        Map<String, Object> model = memSearcher.search(links, easySearchParse, pageRequest, (link -> StringUtils.isBlank(paramValue) || StringUtils.containsIgnoreCase(link.getUrl(), paramValue)));
        putAttribute(EASY_SEARCH_DATA, model);

        return forward("/common/easySearch.jsp");
    }

    private void syncLinksInternal() {
        long startTimeMillis = System.currentTimeMillis();
        links = handlerMapping.getHandlerMethods().keySet().stream()
                .flatMap(handlerMapping -> handlerMapping.getPatternsCondition().getPatterns().stream().limit(1))
                .map(Link::new)
                .collect(Collectors.toList());
        LOG.info("同步链接完成，消耗 {} 毫秒", System.currentTimeMillis() - startTimeMillis);
    }

}
