package com.huigou.explorer.converters.mxgraph;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.view.mxGraph;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;

/**
 * @author yonghuan
 */
public class MxProcessConverter extends AbstractMxElementConverter implements MxElementConverter {

    @Override
    public boolean supports(BaseElement baseElement) {
        return baseElement instanceof Process;
    }

    @Override
    public void convert(BpmnModel bpmnModel, Process process, mxGraph graph, BaseElement baseElement) {
        mxGraphModel graphModel = (mxGraphModel) graph.getModel();
        mxCell rootCell = (mxCell) graphModel.getRoot();
        rootCell.setValue(mxDomUtils.createDocument().createElement("object"));
        rootCell.setId("0");
        rootCell.setAttribute("label", process.getName());
        rootCell.setAttribute("code", process.getId());
        parseExecutionListeners(process, rootCell);
    }
}
