package com.huigou.explorer.converters.mxgraph;

import com.alibaba.fastjson.JSON;
import com.mxgraph.model.mxCell;
import org.activiti.bpmn.model.HasExecutionListeners;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yonghuan
 */
public abstract class AbstractMxElementConverter implements MxElementConverter {

    /**
     * 解析流程事件监听器。
     */
    protected void parseExecutionListeners(HasExecutionListeners hasExecutionListeners, mxCell cell) {
        List<Map<String, Object>> listeners = hasExecutionListeners.getExecutionListeners().stream().map(activitiListener -> {
            Map<String, Object> listener = new HashMap<>(3);
            listener.put("event", activitiListener.getEvent());
            listener.put("implementationType", activitiListener.getImplementationType());
            listener.put("implementation", activitiListener.getImplementation());
            listener.put("fieldExtensions",activitiListener.getFieldExtensions());
            return listener;
        }).collect(Collectors.toList());
        if (listeners.size() > 0) {
            cell.setAttribute("executionListeners", JSON.toJSONString(listeners));
        }
    }

}
