package com.huigou.explorer.converters.bpmn;

import com.huigou.explorer.Shape;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.BusinessRuleTask;
import org.activiti.bpmn.model.FlowElement;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author yonghuan
 */
public class BusinessRuleTaskConverter extends AbstractElementConverter implements ElementConverter {

    public BusinessRuleTaskConverter() {
        super(Collections.singletonList(Shape.BUSINESS_RULE_TASK));
    }

    @Override
    protected FlowElement convertInternal(BpmnModel bpmnModel, mxGraphModel graphModel, mxCell cell) {
        BusinessRuleTask businessRuleTask = new BusinessRuleTask();
        List<String> ruleNames = Arrays.stream(StringUtils.split(cell.getAttribute("ruleNames"), ","))
                .filter(StringUtils::isNotBlank)
                .collect(Collectors.toList());
        businessRuleTask.setRuleNames(ruleNames);
        List<String> inputVariables = Arrays.stream(StringUtils.split(cell.getAttribute("inputVariables", ",")))
                .filter(StringUtils::isNotBlank)
                .collect(Collectors.toList());
        businessRuleTask.setInputVariables(inputVariables);
        businessRuleTask.setResultVariableName(cell.getAttribute("resultVariableName"));
        // 设置是否排除某些规则
        businessRuleTask.setExclude("true".equals(cell.getAttribute("exclude")));
        return businessRuleTask;
    }
}
