package com.huigou.explorer;

import org.activiti.bpmn.model.*;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author yonghuan
 */
public enum Shape {

    START_EVENT("workflow.start_events.general_start", StartEvent.class),
    END_EVENT("workflow.end_events.end_event", EndEvent.class),
    END_ERROR_EVENT("workflow.end_events.end_error_event", EndEvent.class),
    END_CANCEL_EVENT("workflow.end_events.end_cancel_event", EndEvent.class),
    END_TERMINATE_EVENT("workflow.end_events.end_terminate_event", EndEvent.class),
    USER_TASK("workflow.activities.user_task", UserTask.class),
    SERVICE_TASK("workflow.activities.service_task", ServiceTask.class),
    BUSINESS_RULE_TASK("workflow.activities.business_rule_task", BusinessRuleTask.class),
    MANUAL_TASK("workflow.activities.manual_task", ManualTask.class),
    SCRIPT_TASK("workflow.activities.script_task", ScriptTask.class),
    RECEIVE_TASK("workflow.activities.receive_task",ReceiveTask.class),
    CALL_ACTIVITY("workflow.activities.call_activity",CallActivity.class),
    PARALLEL_GATEWAY("workflow.gateways.parallel_gateway", ParallelGateway.class),
    EXCLUSIVE_GATEWAY("workflow.gateways.exclusive_gateway", ExclusiveGateway.class),
    INCLUSIVE_GATEWAY("workflow.gateways.inclusive_gateway", InclusiveGateway.class),
    EVENT_GATEWAY("workflow.gateways.event_gateway", EventGateway.class);

    public final String fullName;
    public final String simpleName;
    public final Class<? extends BaseElement> modelClass;

    Shape(java.lang.String fullName, Class<? extends BaseElement> modelClass) {
        this.fullName = fullName;
        simpleName = StringUtils.substringAfterLast(fullName, ".");
        this.modelClass = modelClass;
    }

    public static Optional<Shape> of(String fullName) {
        return Arrays.stream(Shape.values())
                .filter(shape -> shape.fullName.equals(fullName))
                .findAny();
    }
}
