package com.topsunit.query.binding;

import com.topsunit.query.QueryDescriptorHolder;

import java.lang.reflect.Method;

/**
 * 用于获取 {@link com.huigou.data.query.model.QueryDescriptor}。
 *
 * @author yonghuan
 * @since 1.1.3
 */
final class ObtainQueryDescriptorInvokeStrategy implements InvokeStrategy {

    @Override
    public boolean supports(InvokeContext invokeContext, Method method, Object[] args) {
        return QueryDescriptorHolder.class.isAssignableFrom(invokeContext.getMapperInterface())
                && "getQueryDescriptor".equals(method.getName())
                && method.getParameters().length == 1
                && method.getParameters()[0].getType() == String.class;
    }

    @Override
    public Object invoke(InvokeContext invokeContext, Method method, Object[] args) {
        return invokeContext.getSqlExecutor().getQuery(invokeContext.getXml(), (String) args[0]);
    }
}
