package com.topsunit.query.binding;

import com.huigou.data.query.executor.SQLExecutorDao;

/**
 * @author yonghuan
 * @since 1.1.3
 */
final class InvokeContextImpl<T> implements InvokeContext {

    private final Class<T> mapperInterface;
    private final SQLExecutorDao sqlExecutor;
    private final String xml;

    public InvokeContextImpl(Class<T> mapperInterface, String xml, SQLExecutorDao sqlExecutor) {
        this.mapperInterface = mapperInterface;
        this.sqlExecutor = sqlExecutor;
        this.xml = xml;
    }

    @Override
    public Class<T> getMapperInterface() {
        return mapperInterface;
    }

    @Override
    public SQLExecutorDao getSqlExecutor() {
        return sqlExecutor;
    }

    @Override
    public String getXml() {
        return xml;
    }
}
