package com.topsunit.query.annotations;

import java.lang.annotation.*;

/**
 * @author yonghuan
 * @see com.topsunit.query.QueryDescriptorHolder
 */
@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
public @interface Mapper {

    /**
     * 自定义查询SQL文件
     *
     * @return 自定义查询SQL文件
     */
    String xml() default "";

    /**
     * spring bean name
     *
     * @return spring bean name
     * @since 1.1.3
     */
    String value() default "";

}
