package com.topsunit.query.annotations;

import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * @author yonghuan
 */
@Target({METHOD, FIELD})
@Retention(RUNTIME)
@Repeatable(Dictionaries.class)
public @interface Dictionary {

    /**
     * 字典名字。
     */
    String value();

    /**
     * 字段名。
     */
    String field() default "";

}
