﻿var gridManager=null, refreshFlag = false;
$(function () {
	bindEvent();
	initializeGrid();
});

function bindEvent(){
	$("#queryCode").orgTree({
        filter: "psm", excludePos: 1, param: {orgRoot: "55CC78F4502C46F6A174804E9D02F91F"},
        back: {text: "#queryCode"},
        onChange:function(value,data){
        	$('#queryCode').val(data.name);
        }
    });
	
	$('#procName').treebox({
		name : 'procTreeView',
		param: {nodeKindId: "folder,proc"},
		back: {text: "#procName"},
		onChange:function(value,data){
			$('#procFullId').val(data.fullId);
		}
	});
	$('#selectDateRange').combox({onChange:function(){
		setTimeout(function(){initdateRange();},10);
	}})
	initdateRange();
}

function initdateRange(){
	var dateRange=$('#selectDateRange').val();
	if(dateRange=='10'){
		UICtrl.enable('#editStartDate');
		UICtrl.enable('#editEndDate');
	}else{
		UICtrl.disable('#editStartDate');
		UICtrl.disable('#editEndDate');
	}
}

function initializeGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler:addOWebServiceConfigType,
		updateHandler: updateHandler,
		deleteHandler: deleteHandler,
		enableHandler: enableHandler,
		disableHandler: disableHandler
	});
    gridManager = UICtrl.grid("#maingrid", {
        columns:  [
                 { display:"接口类型编码", name: "code", width:150, minWidth: 60, type: "string", align: "left"},
       	         { display:"接口类型名称", name: "name", width: 120, minWidth: 60, type: "string", align: "left" },
       	         { display:"Service 对象名称", name: "systemServiceCode", width: 150, minWidth: 60, type: "string", align: "left" },
       	         { display:"接口方法名称",name: "serviceMethod", width:120, minWidth: 60, type: "string", align: "left" },
       	         { display:"接口参数名称",name: "serviceParamters", width: 80, minWidth: 60, type: "string", align: "left" },
       	         { display:"接口参数类型", name: "serviceParamTypes", width: 120, minWidth: 60, type: "string", align: "left" },
				 { display:"是否启用规则验证",name: "isEnableRuleTextView", width:120, minWidth: 60, type: "string", align: "center" },
				 { display:"规则编码",name: "ruleCode", width:120, minWidth: 60, type: "string", align: "left" },
				 { display:"规则名称",name: "ruleName", width:160, minWidth: 60, type: "string", align: "left" },
				 { display:"备注",name: "remark", width: 260, minWidth: 60, type: "string", align: "left" },
				 { display: "状态", name: "status", width: "60", minWidth: 60, type: "string", align: "center",
					render: function (item) {
						return UICtrl.getStatusInfo(item.status);
					}
				 }
       	],
        dataAction: "server",
        url: web_app.name + "/webservice/findWebServiceConfigType.ajax",
        pageSize: 20,
		checkbox:true,
        width: "99.8%",
        height: '100%',
        heightDiff: -2,
		toolbar:toolbarOptions,
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
	var param = $(obj).formToJSON();
	if(!param) return;
	UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
	gridManager.loadData();
} 

function resetForm(obj) {
	$(obj).formClean();
}

/**
 * 新增第三方系统WEB SERVICE 配置
 */
function addOWebServiceConfigType(){
	UICtrl.showAjaxDialog({
		title:"新增类型",
		url:web_app.name+"/webservice/forwardInsertWebServiceConfigTypeDetail.load",
		width: 800,
		height: 400,
		init:initSelectRule,
		ok: doSave,
		close: dialogClose
	});
}

function updateHandler(){
	var row = DataUtil.getSelectedRow(gridManager);
	if(!row){
		return;
	}
	UICtrl.showAjaxDialog({
		title:"修改类型",
		url:web_app.name+"/webservice/forwardUpdateWebServiceConfigTypeDetail.load",
		param:row,
		width: 800,
		height: 400,
		init:initSelectRule,
		ok: doSave,
		close:dialogClose
	});
}

/**
 * 保存表单数据
 */
function doSave(){
	var _self = this;
	var url = "/webservice/saveWebServiceType.ajax";
	$('#submitForm').ajaxSubmit({
		url: web_app.name + url,
		success: function () {
			refreshFlag = true;
			_self.close();
		}
	});
}

//关闭对话框
function dialogClose(){
	if(refreshFlag){
		reloadGrid();
		refreshFlag = false;
	}
}

/**
 * 删除第三方系统WEB SERVICE 配置
 */
function deleteHandler(){
	DataUtil.del({
		action: 'webservice/deleteWebServiceType.ajax',
		gridManager: gridManager, idFieldName: 'id',
		onSuccess: function () {
			reloadGrid();
		}
	});
}
/**
 * 启用第三方系统WEB SERVICE 配置
 */
function enableHandler(){
	updateStatus('您确定要启用选中数据吗?', 1);
}
/**
 * 禁用第三方系统WEB SERVICE 配置
 */
function disableHandler(){
	updateStatus('您确定要禁用选中数据吗?', 0);
}
//修改状态
function updateStatus(message, status) {
	DataUtil.updateById({
		action: 'webservice/updateWebServiceTypeStatus.ajax',
		gridManager: gridManager, param: {status: status},
		message: message,
		onSuccess: function () {
			reloadGrid();
		}
	});
}

/**
 * 加载 规则选择框
 */
function initSelectRule(){
	$("#ruleName").searchbox({
		type : "rule",name : "rule",
		back:{
			code:'#ruleCode',
			name:'#ruleName'
		}
	});
}