﻿var gridManager=null,parameterManager=null, refreshFlag = false;
$(function () {
	initializeUI();
	initializeGrid();
	initializeParameterGrid();
});

function initializeUI(){
	UICtrl.layout("#layout", {leftWidth : 4,heightDiff : -5});
	$("#queryFormBtn").click(function(){
		var param = $("#queryParameterForm").formToJSON();
		if(!param) return;
		UICtrl.gridSearch(parameterManager, param);
	});
}

function initializeParameterGrid() {
	parameterManager = UICtrl.grid("#parameterGrid", {
        columns:  [
            { display:"接口名称", name: "configCode", width: 80, minWidth: 60, type: "string", align: "left" },
            { display:"接口名称", name: "configName", width: 80, minWidth: 60, type: "string", align: "left" },
			{ display:"参数名称", name: "parameterName", width:80, minWidth: 60, type: "string", align: "left"},
			{ display:"本地参数名称", name: "localParameterName", width: 100, minWidth: 60, type: "string", align: "left" }
       	],
        dataAction: "server",
        url: web_app.name + "/sapWebServiceParameter/slicedQueryList.ajax",
        // pageSize: 20,
		param:{status:1},
		// checkbox: true,
        width: "99.8%",
        height: '100%',
        heightDiff: -2,
		onSelectRow:function(data){
			var html=[],parentId=data.id;
			if(!data){
				parentId="";
				html.push($.i18nProp('system.webservice.sap.fields'));
			}else{
				html.push('<span class="tomato-color">[',data.parameterName,']</span>',$.i18nProp('system.webservice.sap.fields'));
			}
			$('#layout').layout('setCenterTitle',html.join(''));
			$("#selectParameterId").val(data.id);
			if (gridManager) {
				UICtrl.gridSearch(gridManager,{parameterId:parentId});
			}
		}
    });
    UICtrl.setSearchAreaToggle(parameterManager);
}

function initializeGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler:addHandler,
		updateHandler: updateHandler,
		deleteHandler: deleteHandler,
		enableHandler: enableHandler,
		disableHandler: disableHandler
	});
	gridManager = UICtrl.grid("#maingrid", {
		columns:  [
			{ display:"字段名称", name: "name", width:100, minWidth: 60, type: "string", align: "left"},
			{ display:"字段编码", name: "code", width: 100, minWidth: 60, type: "string", align: "left" },
			{ display:"本地字段编码", name: "localFieldCode", width: 120, minWidth: 60, type: "string", align: "left" },
			{ display:"备注",name: "remark", width: 220, minWidth: 60, type: "string", align: "left" },
			{ display: "状态", name: "status", width: "60", minWidth: 60, type: "string", align: "center",
				render: function (item) {
					return UICtrl.getStatusInfo(item.status);
				}
			}
		],
		dataAction: "server",
		url: web_app.name + "/sapWebServiceFields/slicedQueryList.ajax",
		pageSize: 20,
		checkbox: true,
		width: "99.8%",
		height: '100%',
		heightDiff: -2,
		// fixedCellHeight: true,
		// selectRowButtonOnly: true,
		toolbar:toolbarOptions
		// ,
		// delayLoad: true
	});
	UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
	var param = $(obj).formToJSON();
	if(!param) return;
	UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
	gridManager.loadData();
} 

function resetForm(obj) {
	$(obj).formClean();
}

/**
 * 新增SAP WEB SERVICE 配置
 */
function addHandler(){
	var selectParameterId=$("#selectParameterId").val();
	if(selectParameterId==''){
		Public.tip('system.webservice.sap.warning.not.parameter');
		return;
	}
	UICtrl.showAjaxDialog({
		title:"新增配置",
		url:web_app.name+"/sapWebServiceFields/forwardInsert.load",
		width: 800,
		height: 400,
		ok: doSave,
		close:dialogClose
	});
}

/**
 * 修改SAP WEB SERVICE 配置
 */
function updateHandler(){
	var row = DataUtil.getSelectedRow(gridManager);
	if(!row){
		return;
	}
	UICtrl.showAjaxDialog({
		title:"修改配置",
		url:web_app.name+"/sapWebServiceFields/forwardUpdate.load",
		width: 800,
		param:row,
		height: 400,
		ok: doSave,
		close:dialogClose
	});
}
/**
 * 删除SAP WEB SERVICE 字段 配置
 */
function deleteHandler(){
	DataUtil.del({
		action: 'sapWebServiceFields/delete.ajax',
		gridManager: gridManager, idFieldName: 'id',
		onSuccess: function () {
			reloadGrid();
		}
	});
}
/**
 * 启用SAP WEB SERVICE 字段 配置
 */
function enableHandler(){
	updateStatus('您确定要启用选中数据吗?', 1);
}
/**
 * 禁用SAP WEB SERVICE 字段 配置
 */
function disableHandler(){
	updateStatus('您确定要禁用选中数据吗?', 0);
}
//修改状态
function updateStatus(message, status) {
	DataUtil.updateById({
		action: 'sapWebServiceFields/updateStatus.ajax',
		gridManager: gridManager, param: {status: status},
		message: message,
		onSuccess: function () {
			reloadGrid();
		}
	});
}

/**
 * 保存表单数据
 */
function doSave(){
	var _self = this;
	var url = "/sapWebServiceFields/save.ajax";
	if(!$("#parameterId").val()){
		$("#parameterId").val($("#selectParameterId").val());
	}
	$('#submitForm').ajaxSubmit({
		url: web_app.name + url,
		success: function () {
			refreshFlag = true;
			_self.close();
		}
	});
}

//关闭对话框
function dialogClose(){
	if(refreshFlag){
		reloadGrid();
		refreshFlag = false;
	}
}