﻿var gridManager=null, refreshFlag = false;
$(function () {
	initializeUI();
	initializeGrid();
});

function initializeUI(){
	UICtrl.initDefaultLayout();
	$('#maintree').commonTree({
		kindId: CommonTreeKind.sapType,
		onClick: onFolderTreeNodeClick
	});
}
function onFolderTreeNodeClick(data,folderId) {
	var html=[],parentId=folderId;
	if(folderId==CommonTreeKind.sapType){
		parentId="";
		html.push($.i18nProp('system.webservice.sap.config'));
	}else{
		html.push('<span class="tomato-color">[',data.name,']</span>',$.i18nProp('system.webservice.sap.config'));
	}
	$('#layout').layout('setCenterTitle',html.join(''));
	$('#treeParentId').val(folderId);
	if (gridManager) {
		UICtrl.gridSearch(gridManager,{folderId:parentId});
	}
}

function initializeGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler:addHandler,
		updateHandler: updateHandler,
		deleteHandler: deleteHandler,
		enableHandler: enableHandler,
		disableHandler: disableHandler
	});
    gridManager = UICtrl.grid("#maingrid", {
        columns:  [
			 { display:"SAP接口名称", name: "name", width:150, minWidth: 60, type: "string", align: "left"},
			 { display:"SAP接口编码", name: "code", width: 150, minWidth: 60, type: "string", align: "left" },
			 { display:"BPM流程编码", name: "bpmFlowCode", width: 150, minWidth: 60, type: "string", align: "left" },
			 { display:"备注",name: "remark", width: 220, minWidth: 60, type: "string", align: "left" },
			 { display: "状态", name: "status", width: "60", minWidth: 60, type: "string", align: "center",
				render: function (item) {
					return UICtrl.getStatusInfo(item.status);
				}
			 }
       	],
        dataAction: "server",
        url: web_app.name + "/sapWebService/slicedQueryList.ajax",
        pageSize: 20,
		checkbox: true,
        width: "99.8%",
        height: '100%',
        heightDiff: -2,
		toolbar:toolbarOptions
		// ,
        // delayLoad: true
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
	var param = $(obj).formToJSON();
	if(!param) return;
	UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
	gridManager.loadData();
} 

function resetForm(obj) {
	$(obj).formClean();
}

/**
 * 新增SAP WEB SERVICE 配置
 */
function addHandler(){
	var parentId=$('#treeParentId').val();
	if(parentId==''){
		Public.tip('common.warning.not.kindtree');
		return;
	}
	UICtrl.showAjaxDialog({
		title:"新增配置",
		url:web_app.name+"/sapWebService/forwardInsert.load",
		width: 800,
		height: 400,
		ok: doSave,
		close:dialogClose
	});
}

/**
 * 修改SAP WEB SERVICE 配置
 */
function updateHandler(){
	var row = DataUtil.getSelectedRow(gridManager);
	if(!row){
		return;
	}
	UICtrl.showAjaxDialog({
		title:"修改配置",
		url:web_app.name+"/sapWebService/forwardUpdate.load",
		width: 800,
		param:row,
		height: 400,
		ok: update,
		close:dialogClose
	});
}
/**
 * 删除第三方系统WEB SERVICE 配置
 */
function deleteHandler(){
	DataUtil.del({
		action: 'sapWebService/delete.ajax',
		gridManager: gridManager, idFieldName: 'id',
		onSuccess: function () {
			reloadGrid();
		}
	});
}
/**
 * 启用第三方系统WEB SERVICE 配置
 */
function enableHandler(){
	updateStatus('您确定要启用选中数据吗?', 1);
}
/**
 * 禁用第三方系统WEB SERVICE 配置
 */
function disableHandler(){
	updateStatus('您确定要禁用选中数据吗?', 0);
}
//修改状态
function updateStatus(message, status) {
	DataUtil.updateById({
		action: 'sapWebService/updateStatus.ajax',
		gridManager: gridManager, param: {status: status},
		message: message,
		onSuccess: function () {
			reloadGrid();
		}
	});
}

/**
 * 保存表单数据
 */
function doSave(){
	var _self = this;
	var url = "/sapWebService/save.ajax";
	$('#submitForm').ajaxSubmit({
		url: web_app.name + url,
		param:{folderId:$('#treeParentId').val()},
		success: function () {
			refreshFlag = true;
			_self.close();
		}
	});
}
/**
 * 修改表单数据
 */
function update(){
	var _self = this;
	var url = "/sapWebService/save.ajax";
	$('#submitForm').ajaxSubmit({
		url: web_app.name + url,
		success: function () {
			refreshFlag = true;
			_self.close();
		}
	});
}

//关闭对话框
function dialogClose(){
	if(refreshFlag){
		reloadGrid();
		refreshFlag = false;
	}
}