function initEditorUi() {
    var editorUiInit = EditorUi.prototype.init;
    EditorUi.prototype.init = function () {
        editorUiInit.apply(this, arguments);
        this.actions.get('export').setEnabled(false);
        if (!Editor.useLocalStorage) {
            var that = this;
            Public.ajax(OPEN_URL,
                {id: $('#process-info #id').val()},
                function (resp) {
                    var enabled = true;
                    if (resp && resp.xml) {
                        var xml = resp.xml;
                        //  xml = atob(resp.xml);
                        var filename = resp.filename;
                        var doc = mxUtils.parseXml(xml);
                        that.editor.setGraphXml(doc.documentElement);
                    }
                    that.actions.get('open').setEnabled(enabled || Graph.fileSupport);
                    that.actions.get('import').setEnabled(true);
                    that.actions.get('save').setEnabled(enabled);
                    that.actions.get('saveAs').setEnabled(false);
                    that.actions.get('export').setEnabled(true);
                    // 不显示网格
                    that.actions.get('grid').funct();
                    // 形状上不显示tooltip
                    that.editor.graph.tooltipHandler.setEnabled(false);
                })
        }
    };

    // Adds required resources (disables loading of fallback properties, this can only
    // be used if we know that all keys are defined in the language specific file)
    mxResources.loadDefaultBundle = false;
    var bundle = mxResources.getDefaultBundle(RESOURCE_BASE, mxLanguage) ||
        mxResources.getSpecialBundle(RESOURCE_BASE, mxLanguage);

    // Fixes possible asynchronous requests
    mxUtils.getAll([bundle, STYLE_PATH + '/default.xml'], function (xhr) {
        // Adds bundle text to resources
        mxResources.parse(xhr[0].getText());

        // Configures the default graph theme
        var themes = new Object();
        themes[Graph.prototype.defaultThemeName] = xhr[1].getDocumentElement();

        // Main
        var editor = new Editor(urlParams['chrome'] == '0', themes);
        editor.setFilename($('#code').val() + '.xml');
        var editorUi = new EditorUi(editor);
        editorUi.sidebar.showShapeAndName = true;
        window.editorUi = editorUi;

    }, function () {
        document.body.innerHTML = '<center style="margin-top:10%;">Error loading resource files. Please check browser console.</center>';
    });
}

/**
 * 获取流程的执行监听器。
 */
function getProcessExecutionListeners() {
    var graph = window.editorUi.editor.graph;
    var cells = this.editorUi.editor.graph.getSelectionCells(), cell;
    if (cells.length == 1) {
        cell = cells[0];
    } else {
        cell = graph.getModel().getRoot();
    }
    var cellValue = graph.getModel().getValue(cell);
    var listeners = cellValue.getAttribute('executionListeners');
    if (listeners) {
        return $.parseJSON(listeners);
    }
    return [];
}

/**
 * 获取流程的执行监听器。
 */
function getTaskListeners() {
    var graph = window.editorUi.editor.graph;
    var cells = this.editorUi.editor.graph.getSelectionCells(), cell;
    if (cells.length == 1) {
        cell = cells[0];
    } else {
        cell = graph.getModel().getRoot();
    }
    var cellValue = graph.getModel().getValue(cell);
    var taskListeners = cellValue.getAttribute('taskListeners');
    if (taskListeners) {
        return $.parseJSON(taskListeners);
    }
    return [];
}

function getCallActivityParameters(type) {
    var graph = window.editorUi.editor.graph;
    var cells = this.editorUi.editor.graph.getSelectionCells(), cell;
    if (cells.length == 1) {
        cell = cells[0];
    } else {
        cell = graph.getModel().getRoot();
    }
    var cellValue = graph.getModel().getValue(cell);
    var parameters = cellValue.getAttribute(type);
    if (parameters) {
        return $.parseJSON(parameters);
    }
    return [];
}


/**
 * 获取当前选中的形状
 * @returns {*}
 */
function getSelectionShape() {
    var selectionCells = editorUi.editor.graph.getSelectionCells(), shape;
    if (selectionCells.length == 1) {
        selectionCell = selectionCells[0];
        var keyValues = _.map(selectionCell.style.split(';'), function (item) {
            return item.split('=')
        });
        shape = _.object(keyValues)['shape'] || '';
        shape = _.last(shape.split('.'));
        if (!shape && selectionCell.edge) {
            shape = 'sequence_flow';
        }
    }
    return shape;
}

$(function () {
    initEditorUi();
});

