var refreshFlag = false,gridManagerDictionary=null,dictDetailgridManager=null;

//数据字典配置
function initDictionaryGrid() {

	var toolbarOptions =[];
	toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addDictionary: {id:'addDictionary',img:'fa-cog',text:'添加',click:function(){
				addDictionary();
			}},
		updateHandler: function(){
			updateDictionary();
		},
		deleteHandler:function(){
			deleteDictionary();
		},
		enableHandler: function(){
			enableDictionary();
		},
		disableHandler: function(){
			disableDictionary();
		},
		syncCache:{id:'syncCache',text:'同步缓存',img:'fa-link',click:function(){
				Public.ajax(web_app.name + "/dictionary/syncCache.ajax");
			}}
	});

	gridManagerDictionary = UICtrl.grid('#dli_dictionary', {
		checkbox: true,
		columns : [
			{ display: "编码", name: "code", width: 150, minWidth: 60, type: "string", align: "left" },
			{ display: "名称", name: "name", width: 150, minWidth: 60, type: "string", align: "left" },
			{ display: "类别", name: "kindId", width: 80, minWidth: 60, type: "string", align: "center",
				render: function (item) {
					return item.kindId==1 ? '用户':'系统';
				}
			},
			{ display: "状态", name: "status", width: 60, minWidth: 60, type: "string", align: "center",
				render: function (item) {
					return UICtrl.getStatusInfo(item.status);
				}
			},
			{ display: "备注", name: "remark", width: 300, minWidth: 60, type: "string", align: "left" }
		],
		dataAction : 'server',
		toolbar: toolbarOptions,
		url : web_app.name + '/safFormslist/slicedQueryFormDictionary.ajax',
		// url: web_app.name+'/dictionary/slicedQuerySysDictionaries.ajax',
		parms : {
			id : getId()
		},
		sortOrder : "asc",
		//toolbar : toolbarOptions,
		width : '99.8%',
		height : '100%',
		heightDiff : -8,
		pageSize:100,
		checkbox : true,
		enabledEdit: false,
		rownumbers : true,
		fixedCellHeight : true,
		selectRowButtonOnly : true,
		onDblClickRow: function(data, rowindex, rowobj) {
			updateDictionary(data);
		}
		//isChecked: f_isChecked,
	});
	UICtrl.setSearchAreaToggle(gridManagerDictionary);
}

//刷新表格
function reloadGridDict() {
	gridManagerDictionary.loadData();
} 

//重置表单
function resetForm(obj) {
	$(obj).formClean();
}

//添加按钮 
function addDictionary() {
	var parentId=$('#dictFolderId').val();
	if(parentId==''){
		Public.tip('请选择类别树。');
		return;
	}
	UICtrl.showAjaxDialog({
		url: web_app.name + '/dictionary/showInsertSysDictionary.load',
		title: "添加系统字典",
		ok: insertDict, 
		width: 770, 
		init: initDict,
		close: dialogCloseDict
	});
}

//编辑按钮
function updateDictionary(data){
	if(!data){
		var rows = gridManagerDictionary.getSelectedRows();
		if(!rows.length){
			Public.tip('请选择数据。'); 
			return; 
	    }
		if(rows.length>1){
			Public.tip('只能选择一条记录编辑!');
			return;
		}
		data=rows[0];
	}
	if(parseInt(data.status) != -1){
		if(parseInt(data.kind) == -1){
			Public.errorTip('该类别的字典无法编辑。'); 
			return;
		}
	}

	UICtrl.showAjaxDialog({
		url: web_app.name + '/dictionary/showUpdateSysDictionary.load',
		title: "修改系统字典",
		param:{id: data.id},
		width: 770,
		ok: updateDict,
		init:initDict,
		close: dialogCloseDict
	});
}

//删除按钮
function deleteDictionary() {
	DataUtil.del({
		action: 'dictionary/deleteSysDictionaries.ajax',
		gridManager: gridManagerDictionary, idFieldName: 'id',
		onCheck: function (data) {
			if (parseInt(data.status) != -1) {
				Public.tip(data.name + '不是草稿状态,不能删除。');
				return false;
			}
		},
		onSuccess: function () {
			reloadGridDict();
		}
	});
}

	//启用
	function enableDictionary(){
		DataUtil.updateById({ action: 'dictionary/updateSysDictionariesStatus.ajax',
			gridManager: gridManagerDictionary,idFieldName:'id', param:{status: 1},
			message:'确实要启用选中数据吗?',
			onSuccess:function(){
				reloadGridDict();
			}
		});
	}
//禁用
	function disableDictionary(){
		DataUtil.updateById({ action: 'dictionary/updateSysDictionariesStatus.ajax',
			gridManager: gridManagerDictionary,idFieldName:'id', param:{status: 0},
			message: '确实要禁用选中数据吗?',
			onSuccess:function(){
				reloadGridDict();
			}
		});
	}

function getId(){
	return $('#id').val();
}

function insertDict() {
	var id = getId();
	if(id!='') {
		return updateDict();
	}
	var detailData = DataUtil.getGridData({gridManager:dictDetailgridManager});
	if(!detailData) {
		return false;
	}
	if(!checkDetailData()){
		return false;
	}
	$('#submitForm').ajaxSubmit({url: web_app.name + '/dictionary/insertSysDictionary.ajax',
		param:{folderId:$('#dictFolderId').val(),detailData:Public.encodeJSONURI(detailData)},
		success: function(id) {
			$('#id').val(id);
			dictDetailgridManager.options.parms['dictionaryId']=id;
			dictDetailgridManager.loadData();
			refreshFlag = true;
		}
	});
}

function checkDetailData(){
	//校验明细中是否存在重复的成员
	var detailData=DataUtil.getGridData({gridManager:dictDetailgridManager,isAllData:true});
	var flag=true,names={},values={};
	$.each(detailData,function(i,o){
		if(names[o.name]){
			Public.tip('成员名称['+o.name+']重复，请检查!');
			flag=false;
			return false;
		}else{
			names[o.name]=1;
		}
		if(values[o.value]){
			Public.tip('成员值['+o.value+']重复，请检查!');
			flag=false;
			return false;
		}else{
			values[o.value]=1;
		}
	});
	return flag;
}

//编辑保存
function updateDict(){
	var detailData = DataUtil.getGridData({ gridManager: dictDetailgridManager, idFieldName: 'id' });
	if(!detailData) {
		return false;
	}
	if(!checkDetailData()){
		return false;
	}
	$('#submitForm').ajaxSubmit({url: web_app.name + '/dictionary/updateSysDictionary.ajax',
		param:{ id: getId(), detailData: Public.encodeJSONURI(detailData)},
		success: function() {
			refreshFlag = true;
			dictDetailgridManager.loadData();
		}
	});
}

//关闭对话框
function dialogCloseDict(){
	if(refreshFlag){
		reloadGridDict();
		refreshFlag=false;
	}
}

function initDict(doc){
	var id=$('#id').length>0?$('#id').val():'';
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler: function(){
			//新增时传入detailId -(new Date().getTime())临时主键
			UICtrl.addGridRow(dictDetailgridManager, {status: -1, sequence: dictDetailgridManager.getData().length + 1});
		},
		deleteHandler: function(){
			DataUtil.delSelectedRows({action:'dictionary/deleteSysDictionaryDetails.ajax',
				gridManagerDictionary:dictDetailgridManager,idFieldName:'id',
				onCheck:function(data){
					if(parseInt(data.status) != -1){
						Public.tip(data.name+'不是草稿状态,不能删除!');
						return false;
					}
				},
				onSuccess:function(){
					dictDetailgridManager.loadData();
				},
				param: {
					dictionaryId: $('#id').val()
				}
			});
		},
		enableHandler: function(){
			enableOrDisableDictDetal(1);
		},
		disableHandler: function(){
			enableOrDisableDictDetal(0);
		}
	});
	var param={dictionaryId: id};
	param[gridManagerDictionary.options['pagesizeParmName']]=1000;
	dictDetailgridManager=UICtrl.grid('#dictDetalGrid', {
		 columns: [
		        { display: "成员名称", name: "name", width: 200, minWidth: 60, type: "string", align: "left",
		        	editor: { type: 'text',required:true}
		        },			        	
				{ display: "成员值", name: "value", width: 250, minWidth: 60, type: "string", align: "left",
					editor: { type: 'text',required:true}
				},
		        { display: "成员类别", name: "typeId", width: 84, minWidth: 60, type: "string", align: "left",
		        	editor: { type:'text'}
				},
		        { display: "排序号", name: "sequence", width: 64, minWidth: 60, type: "string", align: "left",
		        	editor: { type:'spinner',min:1,max:100,mask:'nnn'}
				},
				{ display: "状态", name: "status", width: 70, minWidth: 60, type: "string", align: "left",
					render: function (item) { 
						return UICtrl.getStatusInfo(item.status);
					}
				},
				{ display: "备注", name: "remark", width: 200, minWidth: 60, type: "string", align: "left",
					editor: { type:'text'}
				}
		],
		dataAction: 'server',
		url: web_app.name+'/dictionary/slicedQuerySysDictionaryDetails.ajax',
		parms:param,
		width: '100%', 
		height: '260',
		sortName:'sequence',
		sortOrder:'asc',
		heightDiff: -8,
		toolbar: toolbarOptions,
		enabledEdit: true,
		usePager: true,
		checkbox: true,
		fixedCellHeight: true,
		selectRowButtonOnly: true,
		onBeforeEdit:function(editParm){
			var c = editParm.column;
			if(c.name == 'value'){//启用的数据value 不能编辑
			   return editParm.record['status'] === -1;
			}
			return true;
		},
		onLoadData: function(){
			return $('#id').val()!='';
		}
	});
}
function enableOrDisableDictDetal(status){
	//判断是否存在新增数据,如果存在则先提示用户保存
	var data=DataUtil.getGridData({gridManager: dictDetailgridManager});
	if(data.length>0){
		Public.tip("数据已经改变,请执行保存后再执行该操作。");
		return false;
	}
	var message= status == 1 ? '确实要启用选中数据吗?':'确实要禁用选中数据吗?';
	DataUtil.updateById({ action: 'dictionary/updateSysDictionaryDetailsStatus.ajax',
		gridManager: dictDetailgridManager,idFieldName:'id', param:{status: status},
		message: message,
		onSuccess:function(){
			dictDetailgridManager.loadData();
		}
	});	
}
