var gridManagerCoderule = null, refreshFlag = false;

//编码规则列表
function initCoderuleGrid() {

	var toolbarOptions =[];
	toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addCodeRule: {id:'addCodeRule',img:'fa-cog',text:'添加',click:function(){
				addCodeRule();
			}},

		updateHandler: function(){
			updateCodeRule();
		},
		deleteHandler: function(){
			deleteCodeRule();
		}
	});

	gridManagerCoderule = UICtrl.grid('#dli_coderule', {
		checkbox: true,
		columns : [
			{ display: "编码", name: "code", width: 120, minWidth: 60, type: "string", align: "left" },
			{ display: "名称", name: "name", width: 140, minWidth: 60, type: "string", align: "left" },
			{ display: "编码规则", name: "rule", width: 200, minWidth: 60, type: "string", align: "left" },
			{ display: "当前值", name: "currentValue", width: 100, minWidth: 60, type: "string", align: "left" },
			{ display: "最后更新日期", name: "lastModifiedDate", width: 140, minWidth: 60, type: "datetime", align: "left" }
		],
		dataAction : 'server',
		toolbar: toolbarOptions,
		//url : web_app.name + '/safFormslist/slicedQueryGridFields.ajax',
		url: web_app.name+'/codeBuildRule/slicedQueryCodeBuildRules.ajax',
		parms : {
			type:"list",folderId:getParentId(),id:$("#formId").val()
		},
		sortOrder : "asc",
		width : '99.8%',
		height : '100%',
		heightDiff : -8,
		pageSize:100,
		checkbox : true,
		enabledEdit: false,
		rownumbers : true,
		fixedCellHeight : true,
		selectRowButtonOnly : true
		//isChecked: f_isChecked,
	});
	//function f_isChecked(data)
	//{
	//	if (data.seled == 1){
	//		return true;
	//	}
	//	return false;
	//}
	UICtrl.setSearchAreaToggle(gridManagerCoderule);
}

function query(obj) {
	var param = $(obj).formToJSON();
	UICtrl.gridSearch(gridManagerCoderule, param);
}

function reloadGridCodeRule() {
	gridManagerCoderule.loadData();
} 

function resetForm(obj) {
	$(obj).formClean();
}

function getParentId(){
	return $('#ruleFolderId').val();
}

function addCodeRule() {
	if(Public.isBlank(getParentId())){
		Public.tip('请选择类别树。'); 
		return;
	}
	
	UICtrl.showAjaxDialog({
		url: web_app.name + '/codeBuildRule/showInsertCodeBuildRule.load',
		title: "添加单据编号规则",
		width: 340, 
		ok: insertCodeRule,
		close: dialogCloseCodeRule
		});
}

function updateCodeRule(id){
	if(!id){
		var id = DataUtil.getUpdateRowId(gridManagerCoderule);
		if (!id){ return; }
	}
	UICtrl.showAjaxDialog({
		url: web_app.name + '/codeBuildRule/showUpdateCodeBuildRule.load',
		title: "修改单据编号规则",
		width: 340, 
		param:{id:id}, 
		ok: updateRule,
		close: dialogCloseCodeRule
		});
}

function deleteCodeRule(){
	DataUtil.del({action:'codeBuildRule/deleteCodeBuildRules.ajax',
		gridManager:gridManagerCoderule,idFieldName:'id',
		onSuccess:function(){
			reloadGridCodeRule();
		}
	});
}

function insertCodeRule() {
	var codeBuildRuleId=$('#codeBuildRuleId').val();
	if(codeBuildRuleId!='') return update();
	$('#submitForm').ajaxSubmit({url: web_app.name + '/codeBuildRule/insertCodeBuildRule.ajax',
		param:{folderId:$('#ruleFolderId').val()},
		success : function(id) {
			$('#codeBuildRuleId').val(id);
			refreshFlag = true;
		}
	});
}

function updateRule(){
	$('#submitForm').ajaxSubmit({url: web_app.name + '/codeBuildRule/updateCodeBuildRule.ajax',
		success : function() {
			refreshFlag = true;
		}
	});
}


function dialogCloseCodeRule(){
	if(refreshFlag){
		reloadGridCodeRule();
		refreshFlag=false;
	}
}