<%@ page contentType="text/html; charset=UTF-8" %>
<%@ page import="com.huigou.context.ContextUtil" %>
<%@ page import="com.huigou.util.Constants" %>
<%@ taglib uri="http://www.opensymphony.com/sitemesh/decorator" prefix="decorator" %>
<%@ taglib uri="http://www.opensymphony.com/sitemesh/page" prefix="page" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="/WEB-INF/JSTLFunction.tld" prefix="f" %>
<%
    String token = (String) ContextUtil.getSession().getAttribute(Constants.CSRF_TOKEN);
    response.setHeader("Pragma", "No-cache");
    response.setHeader("Cache-Control", "No-cache");
    response.setDateHeader("Expires", -1);
    response.setHeader("Cache-Control", "No-store");

    String serverHost = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
    String basePath = serverHost + request.getContextPath();
    request.setAttribute("basePath", basePath);
%>
<!DOCTYPE html>
<html>
<head>
    <meta charset=utf-8>
    <meta http-equiv=X-UA-Compatible content="IE=edge">
    <meta name=viewport content="width=device-width,initial-scale=1">
    <link rel="shortcut icon" href=favicon.ico>
    <link rel=stylesheet href=http://at.alicdn.com/t/font_1869570_2qzt87owi9d.css>
    <title></title>
    <meta name=description content="Form designer based on Vue, makes form development simple and efficient">
    <script type="application/javascript">
        var basePath = '${basePath}';
    </script>
    <style>html, body {
        height: 100%;
    }

    #app {
        height: 100%;
        position: relative;

    }

    .iconfont {
        font-family: "iconfont" !important;
        font-size: 16px;
        font-style: normal;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
    }

    .lds-roller {
        display: inline-block;
        position: relative;
        width: 64px;
        height: 64px;
    }

    .lds-roller div {
        animation: lds-roller 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite;
        transform-origin: 32px 32px;
    }

    .lds-roller div:after {
        content: " ";
        display: block;
        position: absolute;
        width: 6px;
        height: 6px;
        border-radius: 50%;
        background: #409EFF;
        margin: -3px 0 0 -3px;
    }

    .lds-roller div:nth-child(1) {
        animation-delay: -0.036s;
    }

    .lds-roller div:nth-child(1):after {
        top: 50px;
        left: 50px;
    }

    .lds-roller div:nth-child(2) {
        animation-delay: -0.072s;
    }

    .lds-roller div:nth-child(2):after {
        top: 54px;
        left: 45px;
    }

    .lds-roller div:nth-child(3) {
        animation-delay: -0.108s;
    }

    .lds-roller div:nth-child(3):after {
        top: 57px;
        left: 39px;
    }

    .lds-roller div:nth-child(4) {
        animation-delay: -0.144s;
    }

    .lds-roller div:nth-child(4):after {
        top: 58px;
        left: 32px;
    }

    .lds-roller div:nth-child(5) {
        animation-delay: -0.18s;
    }

    .lds-roller div:nth-child(5):after {
        top: 57px;
        left: 25px;
    }

    .lds-roller div:nth-child(6) {
        animation-delay: -0.216s;
    }

    .lds-roller div:nth-child(6):after {
        top: 54px;
        left: 19px;
    }

    .lds-roller div:nth-child(7) {
        animation-delay: -0.252s;
    }

    .lds-roller div:nth-child(7):after {
        top: 50px;
        left: 14px;
    }

    .lds-roller div:nth-child(8) {
        animation-delay: -0.288s;
    }

    .lds-roller div:nth-child(8):after {
        top: 45px;
        left: 10px;
    }

    @keyframes lds-roller {
        0% {
            transform: rotate(0deg);
        }
        100% {
            transform: rotate(360deg);
        }
    }</style>
    <script>window.dataLayer = window.dataLayer || [];

    function gtag() {
        dataLayer.push(arguments);
    }

    gtag('js', new Date());

    gtag('config', 'UA-145160307-3');</script>
    <link href=${basePath}/formdesign/form-making/css/app.css rel=preload as=style>
    <link href=${basePath}/formdesign/form-making/css/chunk-vendors.css rel=preload as=style>
    <link href=${basePath}/formdesign/form-making/js/app.js rel=preload as=script>
    <link href=${basePath}/formdesign/form-making/js/chunk-vendors.js rel=preload as=script>
    <link href=${basePath}/formdesign/form-making/css/chunk-vendors.css rel=stylesheet>
    <link href=${basePath}/formdesign/form-making/css/app.css rel=stylesheet>
</head>
<body>
<input type="hidden" id="csrfTokenElement" value="<%=token%>"/>
<input type="hidden" id="formNo" value="<%=request.getParameter("formno")%>">
<div id=app>
    <div style="height: 100%; width: 100%; display: flex; justify-content: center; align-items: center;">
        <div class=lds-roller>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
        </div>
    </div>
</div>
<script src=${basePath}/formdesign/form-making/js/chunk-vendors.js></script>
<script src=${basePath}/formdesign/form-making/js/app.js></script>
</body>
</html>
