<%@ page contentType="text/html; charset=utf-8" language="java" %>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="date,layout,grid,combox,tree,comboDialog,attachment"/>
</head>
<body>
<div class="container-fluid">
    <x:billTitle title="请假单" needStatus="false" needPerson="true"/>
    <div id="purchaseBudgetList">
        <div id="purchaseBudgetGrid"></div>
    </div>
    <div class="blank_div clearfix"></div>
    <form class="hg-form" method="post" action="" id="submitForm">
        <x:hidden name="id" id="leaveId"/>
        <x:hidden name="billCode"/>
        <x:hidden name="fillinDate" type="datetime"/>
        <x:hidden name="fullId"/>
        <x:hidden name="organId"/>
        <x:hidden name="organName"/>
        <x:hidden name="deptId"/>
        <x:hidden name="deptName"/>
        <x:hidden name="positionId"/>
        <x:hidden name="positionName"/>
        <x:hidden name="personMemberId"/>
        <x:hidden name="personMemberName"/>
        <div class="hg-form-cols">
            <div class="hg-form-row">
                <x:selectC name="secretLevel" title="密级" required="true" label="密级" labelCol="2" fieldCol="2"
                           dictionary="securityGrade"/>
                <x:inputC name="secrecyLimit" title="密级年限" required="false" label="密级年限" labelCol="2" fieldCol="2"
                          mask="nnn"/>
            </div>
            <div class="hg-form-row">
                <x:inputC name="days" title="请假天数" required="true" label="请假天数" labelCol="2" fieldCol="6"
                          maxlength="32" spinner="true" mask="nnn" dataOptions="min:1"/>
            </div>
        </div>
    </form>
    <div class="blank_div clearfix"></div>
    <x:fileList id="fileList" bizCode="demoLeave" title="附件" bizId="id"/>
    <div id="showAttachmentExplain"></div>
</div>
<script>
    $(function () {
        // 初始化文件上传控件
        $('#fileList').fileList();
    });

    /**
     * 流程引擎回调设置请假申请的id
     * @param value 请假申请的id
     */
    function setId(leaveId) {
        $("#leaveId").val(leaveId);
        // 为文件上传控件绑定业务id
        $('#fileList').fileList({
            bizId: leaveId
        });
    }

    /**
     * 流程引擎获取请假申请id的回掉方法。
     * @return 请假申请的id
     */
    function getId() {
        return $("#leaveId").val() || "";
    }

    /**
     * 获取表单的密级
     */
    function getSecretLevel() {
        return $('#secretLevel').val();
    }
</script>
</body>
</html>
