package com.huigou.bpm.webservice.utils;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XmlMapAdapter extends XmlAdapter<StringObjectMap,Map<String,String>> {
    @Override
    public Map<String, String> unmarshal(StringObjectMap entry) throws Exception {
        Map<String, String> result = new HashMap<String, String>();
        for(StringObjectMapEntry e :entry.getEntries()){
            result.put(e.getKey(),e.getValue());
        }
        return result;
    }

    @Override
    public StringObjectMap marshal(Map<String, String> v) throws Exception {
        StringObjectMap result = new StringObjectMap();
        List<StringObjectMapEntry> entries = new ArrayList<StringObjectMapEntry>();
        for(Map.Entry<String, String> entry:v.entrySet()){
            StringObjectMapEntry map = new StringObjectMapEntry();
            map.setKey(entry.getKey());
            map.setValue(entry.getValue());
            entries.add(map);
        }
        result.setEntries(entries);
        return result;
    }
}
