package com.huigou.bpm.webservice.controller;

import com.huigou.bpm.webservice.call.application.SapWebServiceParameterApplication;
import com.huigou.bpm.webservice.call.domain.model.SapWebServiceConfig;
import com.huigou.bpm.webservice.call.domain.model.SapWebServiceParameter;
import com.huigou.bpm.webservice.call.domain.query.SapWebServiceParameterQueryRequest;
import com.huigou.bpm.webservice.common.SapCommonContraller;
import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

@Controller
@ControllerMapping("sapWebServiceParameter")
public class SapWebServiceParameterController extends CommonController implements SapCommonContraller {

    @Override
    protected String getPagePath() {
        return "/system/webservice/sap/";
    }

    private String pageName = "sapWebServiceParameter";

    @Autowired
    private SapWebServiceParameterApplication sapWebServiceParameterApplication;


    @Override
    public String forwardPage() {
        return forward(pageName);
    }

    @Override
    public String forwardInsert() {
        return forward(pageName+"Detail");
    }

    @Override
    public String forwardUpdate() {
        SDO sdo = this.getSDO();
        return forward(pageName+"Detail",sdo);
    }

    @Override
    public String slicedQueryList() {
        SDO sdo = this.getSDO();
        SapWebServiceParameterQueryRequest request = sdo.toQueryRequest(SapWebServiceParameterQueryRequest.class);
        Map<String,Object> data = sapWebServiceParameterApplication.slicedQueryBean(request);
        return toResult(data);
    }

    @Override
    public String save() {
        SDO sdo = this.getSDO();
        SapWebServiceParameter config = sdo.toObject(SapWebServiceParameter.class);
        sapWebServiceParameterApplication.saveBean(config);
        return success();
    }

    @Override
    public String delete() {
        SDO sdo = getSDO();
        List<String> ids = sdo.getIds();
        sapWebServiceParameterApplication.deleteBean(SapWebServiceParameter.class,ids);
        return success();
    }

    @Override
    public String update() {
        SDO sdo = this.getSDO();
        SapWebServiceParameter config = sdo.toObject(SapWebServiceParameter.class);
        sapWebServiceParameterApplication.updateBean(config);
        return success();
    }

    public String updateStatus(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        Integer status = sdo.getInteger(CommonDomainConstants.STATUS_FIELD_NAME);
        sapWebServiceParameterApplication.updateStatus(ids,status, SapWebServiceParameter.class);
        return success();
    }
}
