package com.huigou.bpm.webservice.controller;

import com.huigou.bpm.webservice.call.application.SapWebServiceConfigApplication;
import com.huigou.bpm.webservice.call.domain.model.SapWebServiceConfig;
import com.huigou.bpm.webservice.call.domain.query.SapWebServiceConfigQueryRequest;
import com.huigou.bpm.webservice.common.SapCommonContraller;
import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

@Controller
@ControllerMapping("sapWebService")
public class SapWebServiceConfigController extends CommonController implements SapCommonContraller {

    @Override
    protected String getPagePath() {
        return "/system/webservice/sap/";
    }

    private String pageName = "sapWebServiceConfig";

    @Autowired
    private SapWebServiceConfigApplication sapWebServiceConfigApplication;


    @Override
    public String forwardPage() {
        return forward(pageName);
    }

    @Override
    public String forwardInsert() {
        return forward(pageName+"Detail");
    }

    @Override
    public String forwardUpdate() {
        SDO sdo = this.getSDO();
        return forward(pageName+"Detail",sdo);
    }

    @Override
    public String slicedQueryList() {
        SDO sdo = this.getSDO();
        SapWebServiceConfigQueryRequest request = sdo.toQueryRequest(SapWebServiceConfigQueryRequest.class);
        Map<String,Object> data = sapWebServiceConfigApplication.slicedQueryBean(request);
        return toResult(data);
    }

    @Override
    public String save() {
        SDO sdo = this.getSDO();
        SapWebServiceConfig config = sdo.toObject(SapWebServiceConfig.class);
        sapWebServiceConfigApplication.saveBean(config);
        return success();
    }

    @Override
    public String delete() {
        SDO sdo = getSDO();
        List<String> ids = sdo.getIds();
        sapWebServiceConfigApplication.deleteBean(SapWebServiceConfig.class,ids);
        return success();
    }

    @Override
    public String update() {
        SDO sdo = this.getSDO();
        SapWebServiceConfig config = sdo.toObject(SapWebServiceConfig.class);
        sapWebServiceConfigApplication.updateBean(config);
        return success();
    }

    public String updateStatus(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        Integer status = sdo.getInteger(CommonDomainConstants.STATUS_FIELD_NAME);
        sapWebServiceConfigApplication.updateStatus(ids,status,SapWebServiceConfig.class);
        return success();
    }
}
