package com.huigou.bpm.webservice.call.sapclient;

import com.huigou.cache.SystemCache;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;

import java.util.Properties;

public class DestinationProvider {
    private static JCoDestination destination;

    static {
        final DestinationDataProviderImp providerImp = new DestinationDataProviderImp();
        final Properties props = getProperties("SAP_CLIENT");
        providerImp.addDestinationProperties("SAP_CLIENT", props);
        Environment.registerDestinationDataProvider(providerImp);

        try {
            destination = JCoDestinationManager.getDestination("SAP_CLIENT");
        } catch (JCoException e) {
            e.printStackTrace();
        }
    }

    public static JCoDestination getDestination(String destName) throws JCoException {
        return destination;
    }

    private static Properties getProperties(String destName) {
        Properties props = new Properties();
        //SAP服务器(应用服务器)
        props.setProperty(DestinationDataProvider.JCO_ASHOST,
                SystemCache.getParameter("sap.ws.jco.client.ashost", String.class));
        //SAP系统编号(实例编号)
        props.setProperty(DestinationDataProvider.JCO_SYSNR,
                SystemCache.getParameter("sap.ws.jco.client.sysnr", String.class));
        //SAP集团(例：300、500、401)
        props.setProperty(DestinationDataProvider.JCO_CLIENT,
                SystemCache.getParameter("sap.ws.jco.client.client", String.class));
        //SAP用户名
        props.setProperty(DestinationDataProvider.JCO_USER,
                SystemCache.getParameter("sap.ws.jco.client.user", String.class));
        //SAP密码
        props.setProperty(DestinationDataProvider.JCO_PASSWD,
                SystemCache.getParameter("sap.ws.jco.client.passwd", String.class));
        //SAP登录语言 ZH\EN ZH是中文 EN是英文
        props.setProperty(DestinationDataProvider.JCO_LANG,
                SystemCache.getParameter("sap.ws.jco.client.lang", String.class));
        return props;
    }
}
