package com.huigou.bpm.webservice.call.domain.model;

import com.huigou.data.domain.model.BaseInfoWithFolderAbstractEntity;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * WebService接口配置表
 */
@Entity
@Table(name = "TBPM_WEB_SERVICE_SAP_CONFIG")
@Setter@Getter
public class SapWebServiceConfig extends BaseInfoWithFolderAbstractEntity {
    /**
     * bpm流程节点编码
     */
    @Column(name="BPM_FLOW_CODE")
    private String bpmFlowCode;
    /**
     * WebService wsdl访问地址：不包含项目地址（http://10.15.65.151:8000/sap）
     */
    @Column(name = "URL")
    private String url;
    /**
     * 接口类包路径
     */
    @Column(name = "PACKAGE_PATH")
    private String packagePath;
    /**
     * 接口类名称
     */
    @Column(name = "INTERFACE_NAME")
    private String interfaceName;
    /**
     * 接口类方法名称
     */
    @Column(name = "METHOD_NAME")
    private String methodName;
    /**
     * 备注
     */
    @Column(name = "REMARK")
    private String remark;
}
