package com.huigou.bpm.webservice.application.impl;

import com.huigou.bpm.webservice.application.OtherSystemConfigApplication;
import com.huigou.bpm.webservice.domain.model.OtherSystemConfig;
import com.huigou.bpm.webservice.domain.query.OtherSystemConfigQueryRequest;
import com.huigou.bpm.webservice.repository.OtherSystemConfigRepository;
import com.huigou.cache.DictUtil;
import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.data.domain.service.CommonDomainService;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

@Service("otherSystemConfigApplication")
public class OtherSystemConfigApplicationImpl extends BaseApplication implements OtherSystemConfigApplication {

    @Autowired
    protected CommonDomainService commonDomainService;

    @Autowired
    private OtherSystemConfigRepository otherSystemConfigRepository;

    @Override
    public Map<String, Object> slicedQueryOtherSystemConfig(OtherSystemConfigQueryRequest request) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH,QUERY_OTHER_SYSTEM_CONFIG);
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor,request);
        queryModel.putDictionary("isEnableRule", DictUtil.getDictionary("yesorno"));
        return this.sqlExecutorDao.executeQuery(queryModel);
    }

    @Override
    public void saveOtherSystemConfig(OtherSystemConfig otherSystemConfig) {
        checkTypeConstraints(otherSystemConfig);
        otherSystemConfigRepository.save(otherSystemConfig);
    }

    @Override
    @Transactional
    public void updateOtherSystemConfigStatus(List<String> ids, Integer status) {
        checkIdsNotEmpty(ids);
        Assert.notNull(status, String.format(CommonDomainConstants.PARAMETER_NOT_NULL_FORMAT, CommonDomainConstants.STATUS_FIELD_NAME));
        commonDomainService.updateStatus(OtherSystemConfig.class,ids,status);
    }

    @Override
    public void deleteOtherSystemConfig(List<String> ids) {
        checkIdsNotEmpty(ids);
        List<OtherSystemConfig> configs = otherSystemConfigRepository.findAll(ids);
        otherSystemConfigRepository.delete(configs);
    }

    /**
     * 检查约束条件，同一个系统接口类型不能重复
     * @param otherSystemConfig
     */
    private void checkTypeConstraints(OtherSystemConfig otherSystemConfig){
        String id = otherSystemConfig.getId();
        if(StringUtil.isBlank(id)){
            id="-";
        }
        Integer count = otherSystemConfigRepository.countBySystemServiceCategoryAndSystemIdAndIdIsNot(otherSystemConfig.getSystemServiceCategory(),otherSystemConfig.getSystemId(),id);
        Assert.isTrue(count==0,"接口类型不能重复添加！");
    }
}
