package com.huigou.bpm.webservice.application;

import com.huigou.bpm.webservice.domain.model.OtherSystemConfig;
import com.huigou.bpm.webservice.domain.query.OtherSystemConfigQueryRequest;

import java.util.List;
import java.util.Map;

/**
 * 第三方系统 webService 配置 接口层
 * @author
 * @date 2020-03-20 11:31
 */
public interface OtherSystemConfigApplication {
    /*
     * 查询文件
     */
    String QUERY_XML_FILE_PATH = "config/webservice/otherSystemConfig.xml";
    /**
     * query SQL NAME
     */
    String QUERY_OTHER_SYSTEM_CONFIG = "otherSystemConfig";

    /**
     * 分页查询第三方系统接口配置
     * @param request
     * @return
     */
    Map<String, Object> slicedQueryOtherSystemConfig(OtherSystemConfigQueryRequest request);

    /**
     * 保存三方系统接口配置
     * @param otherSystemConfig
     */
    void saveOtherSystemConfig(OtherSystemConfig otherSystemConfig);

    /**
     * 修改三方系统接口配置状态
     * @param ids
     * @param status
     */
    void updateOtherSystemConfigStatus(List<String> ids,Integer status);

    /**
     * 删除三方系统接口配置
     * @param ids
     */
    void deleteOtherSystemConfig(List<String> ids);
}
