package test;

import cz.vutbr.web.css.*;
import org.junit.Test;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class JstyleparserTest {

    @Test
    public void test() throws IOException, CSSException {
        String css = Files.readAllLines(Paths.get("E:\\work\\topsunit\\IdeaProjects\\huigou\\huigou-xt\\src\\main\\webapp\\themes\\fontawesome\\css\\font-awesome.min.css"))
                .stream()
                .collect(Collectors.joining("\n"));
        StyleSheet sheet = CSSFactory.parseString(css, null);
        List<String> icons = sheet.stream().filter(block -> block instanceof RuleSet)
                .map(RuleSet.class::cast)
                .filter(rule -> rule.getSelectors().length == 1)
                .filter(rule -> rule.size() == 1)
                .filter(rule -> "content".equals(rule.get(0).getProperty()))
                .map(rule -> rule.getSelectors()[0].get(0).getClassName())
                .collect(Collectors.toList());
    }

}
