package com.huigou.uasp.client;

import com.huigou.uasp.bmp.opm.application.InitPasswordListener;
import com.huigou.uasp.bmp.opm.domain.model.org.Person;
import com.huigou.uasp.tool.mail.EmailSender;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author haifeng
 * @date 2020-05-19  12:12
 * @description 初始化密码时，实现发送邮件
 */
public class InitPasswordEmailNotifier implements InitPasswordListener {

    @Autowired
    private EmailSender mailSender;
    /**
     * 模板
     */
    private String initPswMail;

    public void setInitPswMail(String initPswMail) {
        this.initPswMail = initPswMail;
    }

    @Override
    public void onInitPassword(Person person, String newPassword) {

        Map<String,Object> map = new LinkedHashMap<>(2);
        map.put("person",person);
        map.put("newPsw",newPassword);
        try{
            mailSender.doSend(person.getEmail(),INIT_PSW_MAIL_OBJECT,initPswMail,map);
        }catch (Exception e){
            e.printStackTrace();
        }
    }
}
