package com.huigou.uasp.bmp.opm.controller;


import com.huigou.context.MessageSourceContext;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.opm.application.RoleBizManagementApplication;
import com.huigou.uasp.bmp.opm.domain.query.RoleBizManagementQueryRequest;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

/**
 * 角色业务管理权限
 *
 * @author yonghuan
 */
@ControllerMapping("roleBizManagement")
@Controller
public class RoleBizManagementController extends CommonController {

    @Autowired
    private RoleBizManagementApplication roleBizManagementApplication;

    /**
     * 跳转到角色业务管理权限界面
     */
    public String forwardRoleBizManagement() {
        String roleId = getSDO().getString("roleId");
        Assert.hasText(roleId, MessageSourceContext.getMessage("roleId.not.blank"));
        return forward("RoleBizManagement");
    }

    /**
     * 为角色分配下属
     */
    public String allocateSubordinations() {
        SDO sdo = getSDO();
        String managerId = sdo.getString("managerId");
        List<String> subordinationIds = sdo.getStringList("subordinationIds");
        String manageTypeId = sdo.getString("manageTypeId");
        roleBizManagementApplication.allocateSubordinations(managerId, manageTypeId, subordinationIds);
        return success();
    }

    /**
     * 查询下属
     */
    public String slicedQuerySubordination() {
        RoleBizManagementQueryRequest queryRequest = getSDO().toQueryRequest(RoleBizManagementQueryRequest.class);
        Map<String, Object> result = roleBizManagementApplication.slicedQuerySubordination(queryRequest);
        return toResult(result);
    }

    public String deleteById() {
        roleBizManagementApplication.deleteByIds(getSDO().getIds());
        return success();
    }

    @Override
    protected String getPagePath() {
        return "/system/opm/rolebizmanagement/";
    }

}
