package com.huigou.uasp.bmp.intercept;

import com.huigou.context.Operator;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author yonghuan
 */
public final class CompositeCsrfTokenVerifyStrategy implements CsrfTokenVerifyStrategy {

    /**
     * 代理的校验策略。
     */
    private final List<CsrfTokenVerifyStrategy> delegateStrategies;

    public CompositeCsrfTokenVerifyStrategy(List<CsrfTokenVerifyStrategy> delegateStrategies) {
        this.delegateStrategies = delegateStrategies;
    }

    @Override
    public boolean verify(HttpServletRequest request, Operator operator) {
        return delegateStrategies.stream().filter(delegateStrategy -> delegateStrategy.verify(request, operator))
                .findFirst()
                .isPresent();
    }

}
