package com.huigou.uasp.bmp.fn;

import com.huigou.uasp.bmp.configuration.domain.model.CodeRecycle;
import com.huigou.uasp.bmp.configuration.domain.query.CodeRecycleQuery;

import java.util.List;

/**
 * 编码生成器
 * 
 * @author gongmm
 */
public interface CodeGenerator {

    /**
     * 单据编号
     * 
     * @param bizKindId
     *            业务类别ID
     * @return
     */
    String getNextCode(String bizKindId);

    /**
     * 按步长批量取号
     * 
     * @param bizKindId
     * @param step
     */
    List<String> getNextCodesAsStep(String bizKindId, Integer step);

    /**
     * 回收自定义编号
     *
     * @param code 自定义编码号
     * @param codesNos 回收编码值
     */
    void recycleCodeNos(String code,String[] codesNos);

}
