package com.huigou.uasp.bmp.doc.attachment.application.impl;

import com.huigou.cache.DictionaryDesc;
import com.huigou.cache.SystemCache;
import com.huigou.uasp.bmp.doc.attachment.application.SecrecyLevelComparator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;

import java.util.Map;

/**
 * 基于密级字典的排序字段进行密级大小比较
 *
 * @author yonghuan
 */
public class BasedOnSequenceSecrecyLevelComparator implements SecrecyLevelComparator {

    private String securityGradeDictionaryCode;

    @Value("${securityGradeDictionaryCode}")
    public void setSecurityGradeDictionaryCode(String securityGradeDictionaryCode) {
        this.securityGradeDictionaryCode = securityGradeDictionaryCode;
    }

    @Override
    public int compare(String secrecyLeve1, String secrecyLeve2) {
        Map<String, DictionaryDesc> secrecyLevels = SystemCache.getDictionary(securityGradeDictionaryCode);
        DictionaryDesc sc1 = secrecyLevels.get(secrecyLeve1);
        Assert.notNull(sc1, String.format("无效的密级：%s", secrecyLeve1));
        DictionaryDesc sc2 = secrecyLevels.get(secrecyLeve2);
        Assert.notNull(sc2, String.format("无效的密级：%s", secrecyLeve2));
        return sc1.getSequence().compareTo(sc2.getSequence());
    }
}
