package com.huigou.uasp.bmp.doc.attachment.application.impl;

import com.huigou.context.ThreadLocalUtil;
import com.huigou.uasp.bmp.doc.attachment.application.AttachmentSecretInfoResolver;
import com.huigou.uasp.bmp.doc.attachment.application.SecrecyLevelComparator;
import com.huigou.uasp.bmp.doc.attachment.domain.model.AttachmentConfiguration;
import com.huigou.uasp.bmp.doc.attachment.domain.model.FileInfo;
import com.huigou.uasp.bmp.doc.attachment.repository.AttachmentConfigurationRepository;
import com.huigou.uasp.bmp.opm.application.OrgApplication;
import com.huigou.uasp.bmp.opm.domain.model.org.Person;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import java.util.Objects;

/**
 * @author yonghuan
 */
public abstract class AbstractAttachmentSecretInfoResolver implements AttachmentSecretInfoResolver {

    private AttachmentConfigurationRepository attachmentConfigurationRepository;
    private OrgApplication orgApplication;
    private SecrecyLevelComparator secrecyLevelComparator;
    /**
     * 默认开启密级检查
     */
    private boolean defaultEnableSecret;

    public void setDefaultEnableSecret(boolean defaultEnableSecret) {
        this.defaultEnableSecret = defaultEnableSecret;
    }

    @Autowired
    public void setAttachmentConfigurationRepository(AttachmentConfigurationRepository attachmentConfigurationRepository) {
        this.attachmentConfigurationRepository = attachmentConfigurationRepository;
    }

    @Autowired
    public void setOrgApplication(OrgApplication orgApplication) {
        this.orgApplication = orgApplication;
    }

    @Autowired
    public void setSecrecyLevelComparator(SecrecyLevelComparator secrecyLevelComparator) {
        this.secrecyLevelComparator = secrecyLevelComparator;
    }

    @Override
    public String resolve(FileInfo fileInfo) {
        AttachmentConfiguration attachmentConfiguration = attachmentConfigurationRepository.findByCode(fileInfo.getBizCode());
        if (attachmentConfiguration == null && !defaultEnableSecret) {
            return null;
        }
        if (enableSecret(attachmentConfiguration)) {
            // 1、解析附件密级
            String attachmentSecurityLevel = resolveAttachmentSecurityLevel(fileInfo);
            // 2、校验附件密级是否与人员密级匹配
            Person person = orgApplication.loadPerson(ThreadLocalUtil.getOperator().getUserId());
            boolean personSecurityGradeGreaterThanAttachmentSecurityGrade = secrecyLevelComparator.compare(person.getPersonSecurityGrade(), attachmentSecurityLevel) > -1;
            Assert.isTrue(personSecurityGradeGreaterThanAttachmentSecurityGrade, "附件密级与人员密级不匹配");
            // 3、校验附件密级是否与表单密级匹配
            Assert.hasText(fileInfo.getFormSecretLevel(), "表单密级不能为空");
            boolean formSecurityGradeThanAttachmentSecurityGrade = secrecyLevelComparator.compare(fileInfo.getFormSecretLevel(), attachmentSecurityLevel) > -1;
            Assert.isTrue(formSecurityGradeThanAttachmentSecurityGrade, "附件密级与表单密级不匹配");
            // 4、返回附件密级
            return attachmentSecurityLevel;
        }
        // 未启用密级
        return null;
    }

    private boolean enableSecret(AttachmentConfiguration attachmentConfiguration) {
        boolean enableSecret;
        if (attachmentConfiguration == null) {
            enableSecret = defaultEnableSecret;
        } else {
            if (attachmentConfiguration.getEnableSecret() == null) {
                enableSecret = defaultEnableSecret;
            } else {
                enableSecret = Objects.equals(attachmentConfiguration.getEnableSecret(), 1);
            }
        }
        return enableSecret;
    }

    /**
     * 解析附件密级。
     */
    protected abstract String resolveAttachmentSecurityLevel(FileInfo fileInfo);
}
