package com.huigou.uasp.bmp.configuration.domain.model;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Getter;
import lombok.Setter;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 自定义编码值回收
 * @ Author: chicheng.li
 * @ Date  :  16:42 2021/4/7
 */
@Getter
@Setter
@Entity
@Table(name = "SA_CODE_RECYCLE")
public class CodeRecycle extends AbstractEntity {
    /**
     * 回收编号值
     */
    @Column(name = "CODE_NO", length = 100)
    private String codeNo;
    /**
     * 对应配置编号
     */
    private String code;
    /**
     * 是否再次利用
     */
    @Column(name = "IS_RECYCLE", length = 20)
    private String isRecycle;
    /**
     * 再次使用时间
     */
    @Column(name = "USE_DATE")
    private Date useDate;
    /**
     * 创建时间
     */
    @Column(name = "CREATED_DATE")
    private Date createdDate;

    /**
     * 创建人ID
     */
    @Column(name = "CREATED_BY_ID")
    private String createdById;

    /**
     * 创建人
     */
    @Column(name = "CREATED_BY_NAME")
    private String createdByName;
}
