package com.huigou.rule.repository;


import com.huigou.rule.domain.model.Rule;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

public interface RuleRepository extends JpaRepository<Rule,String> {
    /**
     * 根据状态查询规则
     * @param status
     * @return
     */
    List<Rule> findByStatus(Integer status);

    /**
     * 根据编号查询规则
     * @param code
     * @return
     */
    Rule findByCode(String code);

    /**
     * 判断code重复查询
     * @param code
     * @param id
     * @return
     */
    Integer countByCodeAndIdIsNot(String code,String id);
}
