package com.huigou.rule.controller;

import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.rule.application.RuleApplication;
import com.huigou.rule.domain.model.Rule;
import com.huigou.rule.domain.query.RuleQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.log.annotation.LogInfo;
import com.huigou.uasp.log.domain.model.LogType;
import com.huigou.uasp.log.domain.model.OperationType;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

@Controller
@ControllerMapping("rule")
public class RuleController extends CommonController {

    @Override
    protected String getPagePath() {
        return "/system/rule/";
    }

    @Autowired
    private RuleApplication ruleApplication;

    /**
     * 跳转到业务规则配置列表页面
     *
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.LIST, description = "跳转到业务规则列表页面")
    public String forwardRule() {
        return forward("rule");
    }

    /**
     * 添加业务规则配置详情页面
     *
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.ADD, description = "添加业务规则详情页面")
    public String forwardInsertRule() {
        String folderId = getSDO().getString("folderId");
        putAttribute("folderId", folderId);
        return forward("ruleDetail");
    }

    /**
     * 修改业务规则配置详情页面
     *
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.UPDATE, description = "修改业务规则详情页面")
    public String forwardUpdateRule() {
        SDO sdo = this.getSDO();
        Rule rule = ruleApplication.findByCode(sdo.getString("code"));
        return forward("ruleDetail", rule);
    }

    /**
     * 分页查询业务规则配置列表
     *
     * @return
     */
    @LogInfo(logType = LogType.SYS, operaionType = OperationType.QUERY, description = "分页查询业务规则列表")
    public String slicedQueryRules() {
        SDO sdo = this.getSDO();
        RuleQueryRequest queryRequest = sdo.toQueryRequest(RuleQueryRequest.class);
        return toResult(ruleApplication.slicedQueryRules(queryRequest));
    }

    @LogInfo(logType = LogType.SYS, operaionType = OperationType.ADD, description = "保存业务规则")
    public String saveRule() {
        SDO sdo = this.getSDO();
        Rule rule = sdo.toObject(Rule.class);
        ruleApplication.saveRule(rule);
        return success(rule);
    }

    @LogInfo(logType = LogType.SYS, operaionType = OperationType.ADD, description = "修改业务规则状态")
    public String updateRuleStatus() {
        SDO sdo = getSDO();
        List<String> ids = sdo.getIds();
        Integer status = sdo.getInteger(CommonDomainConstants.STATUS_FIELD_NAME);
        ruleApplication.updateRuleStatus(ids, status);
        return success();
    }

    @LogInfo(logType = LogType.SYS, operaionType = OperationType.ADD, description = "移动业务规则")
    public String moveRules() {
        SDO params = this.getSDO();
        String folderId = params.getString(FOLDER_ID_KEY_NAME);
        List<String> ids = params.getStringList(IDS_KEY_NAME);
        ruleApplication.moveRules(ids, folderId);
        return success();
    }

    @LogInfo(logType = LogType.SYS, operaionType = OperationType.ADD, description = "删除业务规则")
    public String deleteRule() {
        SDO sdo = getSDO();
        List<String> ids = sdo.getIds();
        ruleApplication.deleteRule(ids);
        return success();
    }

    @LogInfo(logType = LogType.SYS, operaionType = OperationType.ADD, description = "部署业务规则到流程引擎")
    public String deployToBpmEngine() {
        List<String> ids = getSDO().getIds();
        ruleApplication.deployToBpmEngine(ids);
        return success();
    }
}
