package com.huigou.uasp.model.application.impl;


import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.*;

import com.huigou.uasp.form.domain.model.FormTables;
import com.huigou.uasp.form.domain.query.SafFormsQueryRequest;
import com.huigou.uasp.form.repository.FormTablesRepository;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import com.google.common.base.CaseFormat;
import com.huigou.cache.SystemCache;
import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.exception.ApplicationException;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.form.repository.SafFormslistRepository;
import com.huigou.uasp.model.application.DbTablesApplication;
import com.huigou.uasp.model.domain.model.DbTables;
import com.huigou.uasp.model.domain.model.TablesMeta;
import com.huigou.uasp.model.domain.query.DbTablesQueryRequest;
import com.huigou.uasp.model.repository.DbTablesRepository;
import com.huigou.uasp.model.repository.TablesMetaRepository;
import com.huigou.uasp.util.Constant;
import com.huigou.uasp.util.Utils;


@Service("dbTablesApplication")
public class DbTablesApplicationImpl extends BaseApplication implements DbTablesApplication {

	// config文件路径
	static String QUERY_XML_FILE_PATH = "config/formdesign/dbtables.xml";

	@Autowired
	private DbTablesRepository dbTablesRepository;
	@Autowired
	private FormTablesRepository formTablesRepository;
	@Autowired
	private  TablesMetaRepository tablesMetaRepository;
	
	@Autowired
	private SafFormslistRepository syfFormsRepository;
	
	@Autowired
	private DbTableService dbTableService;
	
	//@Autowired
//	private ProcessDeletedData processDeletedData;
	
	private String pagePath = "/biz/mdm/model/";
	
	//int x=1;
	@Override
	public Map<String, Object> queryDbTables(DbTablesQueryRequest queryRequest) {
		return this.sqlExecutorDao.executeSlicedQuery(getQueryDescriptor("dbTables"), queryRequest);
	}
	
	
	@Override
	public List<Map<String, Object>> queryDbTableColumns(DbTablesQueryRequest queryRequest){
	  String sql = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH,"dbTables_columns").getSql();
	  return this.sqlExecutorDao.queryToListMap(sql,queryRequest.getTableName(),queryRequest.getTableName());
	}
	
	@Override
	public Map<String, Object> queryUserTables(DbTablesQueryRequest queryRequest) {
		return this.sqlExecutorDao.executeSlicedQuery( this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH,"userTables"), queryRequest);
	}
	
	/*
	  * 表名是否已经存在
	  */
	 public Map<String, Object> queryExistTableName(DbTablesQueryRequest queryRequest){
			Map <String,Object>map=new HashMap<String,Object>();
			  map.put("result","");
			 List <DbTables>list=this.dbTablesRepository.findByTableName(queryRequest.getTableName().toUpperCase());
			if (queryRequest.getId()!=null&&!"".equals(queryRequest.getId())){
			   if (list!=null&&list.size()>0){
				 DbTables dbTables=list.get(0);
				if (!(dbTables.getId()).equals(queryRequest.getId())){
					map.put("result", "表名"+queryRequest.getTableName().toUpperCase()+"已经存在！");
				}
			   }
			} else {
			   if (list.size()>0){
				 map.put("result", "表名"+queryRequest.getTableName().toUpperCase()+"已经存在！");
			   }
			}
			return map;
	 }
	  
	@SuppressWarnings("unchecked")
	@Transactional
	@Override
	public String saveUserTables(DbTablesQueryRequest queryRequest,List <Object>plist){
		//DbTablesQueryRequest queryRequest=new DbTablesQueryRequest();
		Map <String,Object>map=null;
		DbTables dbtable=null;
		String backStr="";
		//判断是否是修改
		if (queryRequest.getId()!=null&&!"".equals(queryRequest.getId())){
			dbtable=dbTablesRepository.findOne(queryRequest.getId());
			dbtable.setTableName(queryRequest.getTableName().toUpperCase());
			dbtable.setName(queryRequest.getName());

		    this.tablesMetaRepository.deleteTablesMetaByTableId(dbtable.getId());
			dbtable=this.dbTablesRepository.saveAndFlush(dbtable);
		} else {
			 dbtable=new DbTables();
			List <DbTables>dblist=this.dbTablesRepository.findByTableName(queryRequest.getTableName().toUpperCase());
		    if (dblist!=null&&dblist.size()>0){	
			   backStr="表名已经存在！";
			   throw new IllegalArgumentException("表名"+queryRequest.getTableName().toUpperCase()+"已经存在！");
		    }
				dbtable.setTableName(queryRequest.getTableName().toUpperCase());
				dbtable.setParentId(queryRequest.getParentId());
				dbtable.setTableType("2");//表类型 
				dbtable.setType("2");
				dbtable.setStatus(1);
				dbtable.setPublished(0);
				dbtable.setName(queryRequest.getName());
			    dbtable=this.dbTablesRepository.saveAndFlush(dbtable);

			  if  (StringUtil.isNotBlank(queryRequest.getFormId())){  //存在表单ID  将添加的模型关联到表单
				  List  <FormTables>formTableList= formTablesRepository.findByFormId(queryRequest.getFormId());

				  FormTables formTables=new FormTables();
				  formTables.setFormId(queryRequest.getFormId());
				  formTables.setTableId(dbtable.getId());
				  formTables.setTableName(dbtable.getTableName());
				  if  (formTableList!=null&&formTableList.size()>0) {
					  formTables.setTableType(2);  //明细表
					  formTables.setDisplayNums(formTableList.get(formTableList.size()-1).getDisplayNums()+1);
				  } else {
					  formTables.setTableType(1);  //主表
					  formTables.setDisplayNums(1);
				  }

				  formTables.setStatus(1);
				  formTablesRepository.saveAndFlush(formTables);
			  }
		}

				TablesMeta tablesMeta=null;

		for (int i=0;i<plist.size();i++) {
			map=(Map<String,Object>)plist.get(i);
			String metaId=map.get("id").toString();
			//String fieldName=map.get("fieldName").toString();
			String fieldCode=map.get("fieldCode").toString();
			tablesMeta=new TablesMeta();
			tablesMeta.setId(Utils.createUuid());
			tablesMeta.setTableId(dbtable.getId());
			tablesMeta.setMetaId(metaId);
			tablesMeta.setFieldCode(fieldCode);
			tablesMeta.setNums(Integer.parseInt(map.get("nums")!=null&&!"".equals(map.get("nums").toString())?map.get("nums").toString():"0"));
			tablesMeta.setStatus(1);
			this.tablesMetaRepository.save(tablesMeta);
			

		}
		return backStr;
	}
	
	@Override
	@Transactional
	public void deleteUserTables(List <String>ids){
	  List<DbTables> dblist = this.dbTablesRepository.findAll(ids); 
	  DbTables obj=null;
	  for (int i=0;i<dblist.size();i++){
		  obj=(DbTables)dblist.get(i);
	      List <TablesMeta>metaLists=this.tablesMetaRepository.findByTableId(obj.getId());
	      for (TablesMeta meta:metaLists){
	        this.tablesMetaRepository.delete(meta);
	      }
	      this.formTablesRepository.deleteFormTablesByTableId(obj.getId());
	      //删除表
		  dbTableService.excuteSQL( new StringBuffer("drop table "+ obj.getTableName()));
	  }
	  this.dbTablesRepository.delete(dblist);
	}
	
	 /**
	  * 删除模型分类 
	  */
	 public void deleteModelClassData(List <String>ids){
		 
		  List<DbTables> dblist = this.dbTablesRepository.findAll(ids); 
		  DbTables obj=null;
		  List <?>list=null;
		  boolean flag=true;
		  for (int i=0;i<dblist.size();i++){
			  obj=(DbTables)dblist.get(i);
			  list=this.dbTablesRepository.findByParentId(obj.getId());
		     if (list!=null&&list.size()>0){
		    	 flag=false;
		    	 throw new ApplicationException(obj.getTableName()+obj.getName()+"存在子节点，不能删除！");
		     }
		  }
		  if (flag){
		    this.dbTablesRepository.delete(dblist);
		  }
	 }
	 
	 
	
	@Override
	public Map<String, Object> querySubDbTables(DbTablesQueryRequest queryRequest) {
        return this.sqlExecutorDao.executeQuery(getQueryDescriptor("dbTables"), queryRequest);
	}
	
	 /**
		 * 查询表中的所有字段
		 * @param queryRequest
		 * @return
		 */
	@Override
	public Map<String, Object> querySubDbTableFields(DbTablesQueryRequest queryRequest){
	    QueryModel queryModel = this.sqlExecutorDao.getQueryModel(getQueryDescriptor("dbTableFields"), queryRequest);

	    Map <String,Object>map=new HashMap<String,Object>();
	    if (queryRequest.getTableId()!=null){
	    	map.put("tableId", queryRequest.getTableId());
	    }
	    if (queryRequest.getTableName()!=null){
	    	map.put("tableName", queryRequest.getTableName());
	    }
	    if (queryRequest.getIsHidden()!=null){
	    	map.put("isHidden", queryRequest.getIsHidden());
	    }
	    queryModel.setSortFieldName("is_hidden");
	    queryModel.setPageSize(100);// 默认100
		queryModel.setPageIndex(1);
	    queryModel.setQueryParams(map);

	   return  this.sqlExecutorDao.executeSlicedQuery(queryModel);

	}

	private QueryDescriptor getQueryDescriptor(String entityName) {
	    return this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, entityName);
	}

	//查询待选择的元数据
	@Override
	public Map<String, Object> queryAlternativeMetaLists(DbTablesQueryRequest queryRequest) {
		QueryDescriptor queryDescriptor = getQueryDescriptor("alternativeMetaData");
		Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryDescriptor,queryRequest);
		return  map;
	}
	//查询已经选择的元数据
	@Override
	public List<Map<String, Object>> querySelectedMetaLists(DbTablesQueryRequest queryRequest) {
		String sql= getQueryDescriptor("selectedMetaData").getSql();
		List<Map<String, Object>> data = this.sqlExecutorDao.queryToListMap(sql, queryRequest.getTableId());
		return data;
	}
 	//************************************************************************************//
	/**
	 * 数据模型发布
	 */
	@Override
	@Transactional
	//parameter: tableId 、 tableType、 （hasProcess=1表示有流程的）
	public Map<String, Object> publishToModelRecordTable(String  tableId,String tableType) {
		Map<String, Object> map = new HashMap<String, Object>();
		String backStr = "";
		String tableName = this.dbTableService.getTableName(tableId);
		try {
			DbTablesQueryRequest queryRequest=new DbTablesQueryRequest();
			queryRequest.setId(tableId);
			queryRequest.setTableId(tableId);
			queryRequest.setTableName(tableName.toUpperCase());

			List<Map<String, Object>> fieldList = this.queryModelRecordSingleFields(queryRequest);

			Map  mapColumn=this.slicedQueryTableColumns(queryRequest);
			List  <Map<String, Object>>existColumns=(List)mapColumn.get("Rows");

			if (fieldList.size() == 0) {
				map.put("result", Constant.NOT_ATTRIBUTE_MODEL);
				return map;
			}
			if  (existColumns!=null&&existColumns.size()>0){  //　表示表已经存在
                 List <Map<String, Object>>newFieldList=new ArrayList<Map<String, Object>>();
                  newFieldList.addAll(fieldList);
          		// 比较字段,添加不存在的字段
                for (Map mapfield:fieldList) {
                    for (Map existfield : existColumns) {
                        if (mapfield.get("fieldCode").toString().equals(existfield.get("columnName").toString())){
                            newFieldList.remove(mapfield);
                            break;
                        }
                    }
                }
                if (newFieldList!=null&&newFieldList.size()>0){  //
					String []fieldCodeTypes=dbTableService.getFieldCodeTypes(newFieldList);
					String []fieldCodes=fieldCodeTypes[0].split(";");
					String []fieldTypes=fieldCodeTypes[1].split(";");

					StringBuffer sb=new  StringBuffer("");
					sb.append("ALTER TABLE ").append(tableName.toUpperCase()).append(" add ( ");
					for (int x=0;x<fieldCodes.length;x++) {
						sb.append(fieldCodes[x]).append(" ").append(fieldTypes[x]);
						if (x<fieldCodes.length-1){
							sb.append(",");
						}
					}
					sb.append(")");
					dbTableService.excuteSQL(sb);
                } else {
					map.put("result", "数据模型已经发布完成！");
					return map;
				}
			} else  {   //新增表
				String[] fieldContent = dbTableService.composizeFieldContent(tableType,fieldList,existColumns);
			    backStr = this.dbTableService.createTable(tableName, fieldContent[0], fieldContent[1]);
			}
			if ("".equals(backStr)) {
				DbTables dbTables=this.dbTablesRepository.findOne(tableId);
				dbTables.setPublished(1);
				this.dbTablesRepository.saveAndFlush(dbTables);
				map.put("result", backStr);
				return map;
			}

		} catch (Exception ex) {
			backStr = ex.getMessage();
			map.put("result", backStr);
			ex.printStackTrace();
		}
		return map;
	}
	// para :tableName
	//@Override
	public List<Map<String, Object>> queryModelRecordSingleFields(DbTablesQueryRequest queryRequest) {
		Map<String, Object> mapData = new HashMap<String, Object>();
		QueryModel queryModel = this.sqlExecutorDao.getQueryModel(getQueryDescriptor("dbTables"), queryRequest);
		queryModel.setPageSize(101);// 默认100
		queryModel.setPageIndex(1);
		// 查询单值字段
		StringBuffer sb = new StringBuffer("");

		sb.append(" select  s.id,s.field_name, s.field_code, s.field_data_type, s.field_length,s.field_decimal")
          .append(",s.code_rule_id,s.is_null,s.field_engname,s.default_value,s.is_primary_key,m.nums ")
          .append(" from saf_tables t ,saf_tables_meta m,saf_meta_Data s ")
          .append(" where m.table_id=t.id and  s.id=m.meta_id  and t.id='").append(queryRequest.getId()).append("'")
          .append(" order by m.nums asc ");
		queryModel.setSortFieldName("nums");
		queryModel.setSql(sb.toString());
		if ("all".equals(queryModel.getExportType())) {// 导出Excel
			queryModel.setExportType(null);
		}
		mapData = this.sqlExecutorDao.executeSlicedQuery(queryModel);
		@SuppressWarnings("unchecked")
		List<Map<String, Object>> list = (List<Map<String, Object>>) mapData.get("Rows");
		return list;
	}


	//查询表的所有列名
	public  Map<String, Object>  slicedQueryTableColumns(DbTablesQueryRequest queryRequest){
		return this.sqlExecutorDao.executeQuery(getQueryDescriptor("queryTableColumns"), queryRequest);
	}

}
