package com.huigou.uasp.model.application;

import java.util.List;
import java.util.Map;

import com.huigou.uasp.form.domain.query.SafFormsQueryRequest;
import org.springframework.transaction.annotation.Transactional;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.uasp.model.domain.query.DbTablesQueryRequest;



public interface DbTablesApplication {
	
	
	/**
	 * 查询模板列表
	 * @param queryRequest
	 * @return
	 */
	Map<String,Object> queryDbTables(DbTablesQueryRequest queryRequest);
	
	/**
	 * 查询表
	 * @param queryRequest
	 * @return
	 */
	 Map<String, Object> querySubDbTables(DbTablesQueryRequest queryRequest);
	 
	 /**
		 * 查询表字段
		 * @param queryRequest
		 * @return
		 */
	Map<String, Object> querySubDbTableFields(DbTablesQueryRequest queryRequest);
	
   /*
   * 查询指定表的列名
   */
	 List<Map<String, Object>> queryDbTableColumns(DbTablesQueryRequest queryRequest);
   /**
    * 查询所有表
    */
	 Map<String, Object> queryUserTables(DbTablesQueryRequest queryRequest);
	 /*
	  * 表名是否已经存在
	  */
	 Map<String, Object> queryExistTableName(DbTablesQueryRequest queryRequest);
   /**
   * 保存选择的表
   */
	 String saveUserTables(DbTablesQueryRequest queryRequest,List <Object>plist);
	 /**
	  * 删除选择的用户表
	  */
	 void deleteUserTables(List <String>ids);
	//查询待选择的元数据
	 Map<String, Object>  queryAlternativeMetaLists(DbTablesQueryRequest queryRequest);

   //查询已经选择的元数据
	 List<Map<String, Object>> querySelectedMetaLists(DbTablesQueryRequest queryRequest);
			
	 //模型发布
     Map<String, Object> publishToModelRecordTable(String tableId,String tableType);
     
     /**
	  * 删除模型分类 
	  */
	 void deleteModelClassData(List <String>ids);

	//查询表的所有列名
	 Map<String, Object>  slicedQueryTableColumns(DbTablesQueryRequest queryRequest);
}
