package com.huigou.uasp.meta.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.huigou.cache.SystemCache;
import com.huigou.exception.ApplicationException;
import com.huigou.uasp.bmp.configuration.domain.model.SysDictionary;
import com.huigou.uasp.meta.application.MetaDataApplication;
import com.huigou.uasp.meta.domain.model.MetaData;
import com.huigou.uasp.meta.domain.model.MetaDataDICT;
import com.huigou.uasp.meta.domain.query.MetaDataQueryRequest;
import com.huigou.uasp.meta.repository.MetaDataDICTRepository;
import com.huigou.uasp.meta.repository.MetaDataRepository;
import com.huigou.uasp.meta.repository.QueryCodeBuildRuleRepository;
import com.huigou.util.ClassHelper;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/**
 * @author BySystem
 * @date 2019年10月17日
 * @Description 的控制类
 */
@Controller
@ControllerMapping(value = "metaData")
public class MetaDataController extends CommonController {

    @Autowired
    private MetaDataRepository mdmMetaDataRepository;

    @Autowired
    private MetaDataApplication mdmMetaDataApplication;
     @Autowired
    private MetaDataDICTRepository mdmMetaDataDICTRepository;
    @Autowired
    private QueryCodeBuildRuleRepository queryCodeBuildRuleRepository;

    @Override
    protected String getPagePath() {
        return "/formdesign/meta/";
    }

    //跳转主页方法
    public String forwardMdmMetaDataList() {
        return forward("mdmMetaDataList");
    }
    
    //跳转主页方法
    public String forwardMdmBusinessTypeList() {
        return forward("mdmBusinessTypeList");
    }

    /**
     * 查询表
     *
     * @return
     */
    public String slicedQueryMdmMetaData() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");//业务树的id
        String fullId = sdo.getString("fullId");//业务树的全路径
        Map<String, Object> data;
        MetaDataQueryRequest queryRequest = sdo.toQueryRequest(MetaDataQueryRequest.class);
      //  queryRequest.setSys_manage_type("11test");
        //根据全路径去进行模糊查询包含当前fullId下面的所有子类。
           data = this.mdmMetaDataApplication.queryMdmMetaData(queryRequest);
            return toResult(data);

    }

    //跳转新增页面
    public String loadMdmMetaDataDetail() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        MetaData mdmMetaData = new MetaData();
        mdmMetaData.setClassifyId(id);
        return forward("mdmMetaDataDetail", mdmMetaData);
    }

    //跳转复制操作页面
    public String loadMdmMetaDataCopy() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        //BusinessType mdmBusinessType = mdmBusinessTypeRepository.findOne(id);
        return forward("mdmMetaDataCopy", null);
    }

    //查询待选数据类型
    public String slicedQueryOldMdmMetaData() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        MetaDataQueryRequest queryRequest = sdo.toQueryRequest(MetaDataQueryRequest.class);
//        MdmMetaData mdmMetaData = mdmMetaDataApplication.loadMdmMetaData(id);
        List<MetaData> mdmMetaData = mdmMetaDataRepository.findByClassifyId(id);
        return packGridDataAndResult(mdmMetaData);
    }

    //查询已选数据类型
    public String slicedQueryNewMdmMetaData() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        String newBusinessDataName = sdo.getString("newBusinessDataName");
        MetaDataQueryRequest queryRequest = sdo.toQueryRequest(MetaDataQueryRequest.class);
        if (StringUtils.isEmpty(newBusinessDataName)) {
            return success();
        } else {
//        MdmMetaData mdmMetaData = mdmMetaDataApplication.loadMdmMetaData(id);
            List<MetaData> mdmMetaData = mdmMetaDataRepository.findByClassifyId(id);
//            mdmMetaData.put("isOld",1);
            List<Map<String,Object>> map = new ArrayList<>();
            for (MetaData metaData : mdmMetaData) {
                Map<String, Object> attribute = ClassHelper.beanToMap(metaData);
                attribute.put("isOld",1);
                map.add(attribute);
            }
            String result = this.packGridDataAndResult(map);
            return result;
        }
    }

    //跳转修改页面
    public String updateMdmMetaData() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        MetaData mdmMetaData = mdmMetaDataApplication.loadMdmMetaData(id);
        MetaDataDICT byMetaDataId = mdmMetaDataDICTRepository.findByMetaDataId(id);
        if (byMetaDataId != null) {
            this.putAttribute("dictCode", byMetaDataId.getDictCode());
        }
        return forward("mdmMetaDataDetail", mdmMetaData);
    }

    //保存方法
    public String saveMdmMetaData() {
        SDO sdo = this.getSDO();
        MetaData entity = (MetaData) sdo.toObject(MetaData.class);
        MetaDataDICT mdmMetaDataDICT = sdo.toObject(MetaDataDICT.class);
        mdmMetaDataDICT.setClassifyId(entity.getClassifyId());
        if (org.apache.commons.lang3.StringUtils.isBlank(entity.getId())){
            String defaultFields="id,form_id,organ_id,dept_id,position_id,person_member_id,full_id,parent_id";

            if (defaultFields.indexOf(entity.getFieldCode())>-1||this.mdmMetaDataRepository.findByFieldCode(entity.getFieldCode())!=null){
                    throw new ApplicationException("字段编码已经存在！");
            }
        }

        //保存MdmMetaData实体
        entity.setStatus(1);
        this.mdmMetaDataRepository.save(entity);
        //得到MdmMetaData实体并赋值给MetaDataId
        mdmMetaDataDICT.setMetaDataId(entity.getId());
        //查询 MdmMetaDataDICT
        MetaDataDICT byMetaDataId = mdmMetaDataDICTRepository.findByMetaDataId(mdmMetaDataDICT.getMetaDataId());
        //根据mdmMetaDataDICT.getDictCode()拿取数据字典里面的byCode实体类。
        SysDictionary byCode = queryCodeBuildRuleRepository.findByCode(mdmMetaDataDICT.getDictCode());
        //保存相应的实体类。
        if (byMetaDataId != null) {
            byMetaDataId.setDictName(byCode.getName());
            byMetaDataId.setDictCode(byCode.getCode());
            this.mdmMetaDataDICTRepository.save(byMetaDataId);
        } else if (byCode != null) {
            mdmMetaDataDICT.setDictName(byCode.getName());
            this.mdmMetaDataDICTRepository.save(mdmMetaDataDICT);
        }
        return success(entity.getId());
    }

    //保存复制方法
    public String saveCopyMdmMetaData() {
        SDO sdo = this.getSDO();
        String newBusinessDataId = sdo.getString("newBusinessDataId");
        List<MetaData> detailData = sdo.getList("detailData", MetaData.class);
        mdmMetaDataApplication.saveCopyMdmMetaData(newBusinessDataId, detailData);
        return success();
    }

    //删除方法
    public String deleteMdmMetaDatas() {
        SDO sdo = this.getSDO();
        MetaDataDICT mdmMetaDataDICT = new MetaDataDICT();
        List<String> ids = sdo.getStringList("ids");
        for (String id : ids) {
            MetaData mdmMetaData = mdmMetaDataApplication.loadMdmMetaData(id);
            if (mdmMetaData.getStatus() == 1) {
                Assert.isTrue(false, " 启用状态的数据无法删除！");
                return success();
            }
            mdmMetaDataDICT.setMetaDataId(id);
            //得到MdmMetaDataDICT实体。
            MetaDataDICT byMetaDataId = this.mdmMetaDataDICTRepository.findByMetaDataId(mdmMetaDataDICT.getMetaDataId());
            if (byMetaDataId != null) {
                this.mdmMetaDataDICTRepository.delete(byMetaDataId);
            }
        }

        this.mdmMetaDataApplication.deleteMdmMetaDataByIds(ids);
        return success();
    }

    //改变启用禁用状态
    public String changeMdmMetaDataStatus() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getStringList("ids");
        Integer status = sdo.getInteger("status");
        for (String id : ids) {
            this.mdmMetaDataApplication.updateStatus(id, status);
        }
        return success();
    }
    
    
    public String getUserDictFolderIds(){
        String dictFolderName = SystemCache.getParameter("formDictFolderName", String.class);
        Map map = new HashMap();
        String dictFolderIds = this.mdmMetaDataApplication.getMdmUserDictFolderIds(dictFolderName);
        map.put("dictFolderIds",dictFolderIds);
        return success(map);
    }

}

