package com.huigou.uasp.meta.application.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;








import org.springframework.util.Assert;

import com.huigou.uasp.meta.application.MetaDataApplication;
import com.huigou.uasp.meta.domain.model.MetaData;
//import com.huigou.uasp.meta.domain.model.MetaDataDICT;
import com.huigou.uasp.meta.domain.query.MetaDataQueryRequest;
//import com.huigou.uasp.meta.repository.MetaDataDICTRepository;
import com.huigou.uasp.meta.repository.MetaDataRepository;
import com.huigou.uasp.util.Constant;

import org.springframework.transaction.annotation.Transactional;

import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.data.query.model.QueryDescriptor;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service("metaDataApplication")
public class MetaDataApplicationImpl extends BaseApplication implements MetaDataApplication {

    static String QUERY_XML_FILE_PATH = "config/formdesign/metaData.xml";
    @Autowired
    private MetaDataRepository mdmMetaDataRepository;
   // @Autowired
   // private MetaDataDICTRepository mdmMetaDataDICTRepository;

    @Override
    public Map<String, Object> queryMdmMetaData(MetaDataQueryRequest queryRequest) {
        return this.sqlExecutorDao.executeSlicedQuery(getQueryDescriptor(), queryRequest);
    }

    private QueryDescriptor getQueryDescriptor() {
        return this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "mdmMetaData");
    }

    @Override
    public MetaData loadMdmMetaData(String id) {
        Assert.hasText(id, Constant.ID_NOT_BLANK);
        return this.mdmMetaDataRepository.findOne(id);
    }


    @Transactional
    @Override
    public void deleteMdmMetaDataByIds(List<String> ids) {
        List<MetaData> list = this.mdmMetaDataRepository.findAll(ids);
        this.mdmMetaDataRepository.delete(list);
    }

    @Override
    public void updateStatus(String id, Integer status) {
        MetaData one = mdmMetaDataRepository.findOne(id);
        one.setStatus(status);
        mdmMetaDataRepository.save(one);
    }

    @Override
    public Map<String, Object> queryMdmMetaDataDICT(MetaDataQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "mdmMetaDataDICT");
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryDescriptor, queryRequest);
        return map;
    }

    @Override
    public void saveCopyMdmMetaData(String newBusinessDataId, List<MetaData> detailData) {
        List<MetaData> byClassifyId = mdmMetaDataRepository.findByClassifyId(newBusinessDataId);
        int dataSize = byClassifyId.size();
        int newDataSize = detailData.size();
     /*  if (dataSize < newDataSize) {
            for (int i = dataSize; i < newDataSize; i++) {
                MetaData mdmMetaData = detailData.get(i);
                String id = mdmMetaData.getId();
                mdmMetaData.setClassifyId(newBusinessDataId);
                mdmMetaData.setId("");
                mdmMetaDataRepository.save(mdmMetaData);
                MetaDataDICT mdmMetaDataDICT = mdmMetaDataDICTRepository.findByMetaDataId(id);
                if(mdmMetaDataDICT!=null){
                    mdmMetaDataDICT.setId("");
                    mdmMetaDataDICT.setClassifyId(newBusinessDataId);
                    MetaData byClassifyIdAndfAndFieldName = mdmMetaDataRepository.findByClassifyIdAndfAndFieldName(newBusinessDataId, mdmMetaData.getFieldName());
                    mdmMetaDataDICT.setMetaDataId(byClassifyIdAndfAndFieldName.getId());
                    mdmMetaDataDICTRepository.save(mdmMetaDataDICT);
                }

            }
            //mdmMetaDataRepository.save(detailData);
        } else {
            Assert.hasText("", Constant.NEW_DATA_NOT_NULL);
        }*/
    }
    
    
    @Override
    public String getMdmUserDictFolderIds(String dictName) {
        StringBuffer sb=new StringBuffer();
        sb=sb.append("select id from SA_CommonTree t start with name = '").append(dictName).append("' connect by t.parent_id= prior id");
        String sql = sb.toString();
        List<String> ids = this.sqlExecutorDao.queryToList(sql, String.class, null);
        String resultIds = String.join(",", ids);
        return resultIds;
    }

}
