package com.huigou.uasp.form.repository;

import com.huigou.uasp.form.domain.model.FormButtons;
import com.huigou.uasp.form.domain.model.FormTree;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface FormTreeRepository extends JpaRepository<FormTree, String>{
	int countByParentId(String parentId);

	List<FormTree> findByCode(String code);

	List<FormTree> findByParentId(String parentId);

	@Modifying
	@Query("delete from FormTree u WHERE u.code=?1 ")
	void deleteFormTreeByCode(String code);

	@Modifying
	@Query("delete from FormTree u WHERE u.parentId=?1")
	void deleteFormTreeByParentId(String parentId);
}
