package com.huigou.uasp.form.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import com.huigou.uasp.form.domain.model.FormTables;



public interface FormTablesRepository extends JpaRepository<FormTables, String>{

	List<FormTables> findByFormId(String formId);


	List<FormTables> findByTableName(String tableName);

	@Query(" from FormTables u WHERE u.formId=?1 and u.tableName=?2")
	List<FormTables> findByFormIdAndTableName(String formId,String tableName);
	
	@Modifying  
	@Query("delete from FormTables u WHERE u.formId=?1 ")    
    void deleteFormTables(String formId);

	@Modifying
	@Query("delete from FormTables u WHERE u.tableId=?1 ")
	void deleteFormTablesByTableId(String tableId);
}
