package com.huigou.uasp.form.repository;
 	import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import com.huigou.uasp.form.domain.model.FormSearchSql;

import java.util.List;

public interface FormSearchSqlRepository extends JpaRepository<FormSearchSql,String>{ 
 
  
   List <FormSearchSql>  findById(String id);
   
   @Query("from FormSearchSql s where  s.formNo=?1 and s.targetField=?2 ") 
   List <FormSearchSql> searchSqlByFormNoAndField(String FormNo,String targetField);
 
   @Query("from FormSearchSql s where  s.formNo=?1 ") 
   List <FormSearchSql> searchSqlByFormNo(String FormNo);
   
   @Query("from FormSearchSql s where  s.formNo=?1 and s.searchName=?2 ") 
   List <FormSearchSql> searchSqlByFormNoAndSearchName(String FormNo,String SearchName);
 
   @Modifying  
   @Query("delete from FormSearchSql u WHERE u.tableName=?1 and u.targetField=?2 ")    
   void deleteSearchSqlByTableField(String tableName,String targetField); 
}
