package com.huigou.uasp.form.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import com.huigou.uasp.form.domain.model.FormButtons;


public interface FormButtonsRepository extends JpaRepository<FormButtons, String>{

	List<FormButtons> findByFormId(String formId);

	@Query(" from FormButtons u WHERE u.formId=?1 and u.buttonType!=3")
	List<FormButtons> findByFormIdNotForm(String formId);

	@Query(" from FormButtons u WHERE u.formId=?1 and u.tableName=?2")
	List<FormButtons> findByFormIdAndTableName(String formId,String tableName);

	@Query(" from FormButtons u WHERE u.formId=?1 and u.buttonKey=?2")
	List<FormButtons> findByFormIdAndButtonKey(String formId,String buttonKey);

	@Modifying  
	@Query("delete from FormButtons u WHERE u.formId=?1 and u.buttonType!=3")
    void deleteFormButtons(String formId); 
	
	@Modifying  
	@Query("delete from FormButtons u WHERE u.formId=?1 and u.buttonKey=?2")    
    void deleteFormButtonsByKey(String formId,String buttonKey);

	@Modifying
	@Query("delete from FormButtons u WHERE u.formId=?1 and u.buttonKey=?2  and u.buttonType=?3")
	void deleteFormButtonsByKeyAndType(String formId,String buttonKey,int buttonType);
}
